// SPDX-License-Identifier: Apache-2.0
//
// Copyright 2008-2016 Conrad Sanderson (http://conradsanderson.id.au)
// Copyright 2008-2016 National ICT Australia (NICTA)
//
// Licensed under the Apache License, Version 2.0 (the "License");
// you may not use this file except in compliance with the License.
// You may obtain a copy of the License at
// http://www.apache.org/licenses/LICENSE-2.0
//
// Unless required by applicable law or agreed to in writing, software
// distributed under the License is distributed on an "AS IS" BASIS,
// WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
// See the License for the specific language governing permissions and
// limitations under the License.
// ------------------------------------------------------------------------

//! \addtogroup spop_misc
//! @{

class spop_scalar_times : public traits_op_passthru {
 public:
  template <typename T1>
  inline static void apply(SpMat<typename T1::elem_type>& out,
                           const SpOp<T1, spop_scalar_times>& in);
};

class spop_cx_scalar_times : public traits_op_passthru {
 public:
  template <typename T1>
  inline static void apply(
      SpMat<std::complex<typename T1::pod_type> >& out,
      const mtSpOp<std::complex<typename T1::pod_type>, T1, spop_cx_scalar_times>& in);
};

class spop_square : public traits_op_passthru {
 public:
  template <typename T1>
  inline static void apply(SpMat<typename T1::elem_type>& out,
                           const SpOp<T1, spop_square>& in);
};

class spop_sqrt : public traits_op_passthru {
 public:
  template <typename T1>
  inline static void apply(SpMat<typename T1::elem_type>& out,
                           const SpOp<T1, spop_sqrt>& in);
};

class spop_cbrt : public traits_op_passthru {
 public:
  template <typename T1>
  inline static void apply(SpMat<typename T1::elem_type>& out,
                           const SpOp<T1, spop_cbrt>& in);
};

class spop_abs : public traits_op_passthru {
 public:
  template <typename T1>
  inline static void apply(SpMat<typename T1::elem_type>& out,
                           const SpOp<T1, spop_abs>& in);
};

class spop_cx_abs : public traits_op_passthru {
 public:
  template <typename T1>
  inline static void apply(SpMat<typename T1::pod_type>& out,
                           const mtSpOp<typename T1::pod_type, T1, spop_cx_abs>& in);
};

class spop_arg : public traits_op_passthru {
 public:
  template <typename T1>
  inline static void apply(SpMat<typename T1::elem_type>& out,
                           const SpOp<T1, spop_arg>& in);
};

class spop_cx_arg : public traits_op_passthru {
 public:
  template <typename T1>
  inline static void apply(SpMat<typename T1::pod_type>& out,
                           const mtSpOp<typename T1::pod_type, T1, spop_cx_arg>& in);
};

class spop_real : public traits_op_passthru {
 public:
  template <typename T1>
  inline static void apply(SpMat<typename T1::pod_type>& out,
                           const mtSpOp<typename T1::pod_type, T1, spop_real>& in);
};

class spop_imag : public traits_op_passthru {
 public:
  template <typename T1>
  inline static void apply(SpMat<typename T1::pod_type>& out,
                           const mtSpOp<typename T1::pod_type, T1, spop_imag>& in);
};

class spop_conj : public traits_op_passthru {
 public:
  template <typename T1>
  inline static void apply(SpMat<typename T1::elem_type>& out,
                           const SpOp<T1, spop_conj>& in);
};

class spop_repelem : public traits_op_default {
 public:
  template <typename T1>
  inline static void apply(SpMat<typename T1::elem_type>& out,
                           const SpOp<T1, spop_repelem>& in);
};

class spop_reshape : public traits_op_default {
 public:
  template <typename T1>
  inline static void apply(SpMat<typename T1::elem_type>& out,
                           const SpOp<T1, spop_reshape>& in);
};

class spop_resize : public traits_op_default {
 public:
  template <typename T1>
  inline static void apply(SpMat<typename T1::elem_type>& out,
                           const SpOp<T1, spop_resize>& in);
};

class spop_floor : public traits_op_passthru {
 public:
  template <typename T1>
  inline static void apply(SpMat<typename T1::elem_type>& out,
                           const SpOp<T1, spop_floor>& in);
};

class spop_ceil : public traits_op_passthru {
 public:
  template <typename T1>
  inline static void apply(SpMat<typename T1::elem_type>& out,
                           const SpOp<T1, spop_ceil>& in);
};

class spop_round : public traits_op_passthru {
 public:
  template <typename T1>
  inline static void apply(SpMat<typename T1::elem_type>& out,
                           const SpOp<T1, spop_round>& in);
};

class spop_trunc : public traits_op_passthru {
 public:
  template <typename T1>
  inline static void apply(SpMat<typename T1::elem_type>& out,
                           const SpOp<T1, spop_trunc>& in);
};

class spop_sign : public traits_op_passthru {
 public:
  template <typename T1>
  inline static void apply(SpMat<typename T1::elem_type>& out,
                           const SpOp<T1, spop_sign>& in);
};

class spop_flipud : public traits_op_passthru {
 public:
  template <typename T1>
  inline static void apply(SpMat<typename T1::elem_type>& out,
                           const SpOp<T1, spop_flipud>& in);
};

class spop_fliplr : public traits_op_passthru {
 public:
  template <typename T1>
  inline static void apply(SpMat<typename T1::elem_type>& out,
                           const SpOp<T1, spop_fliplr>& in);
};

//! @}
