% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/coxphf-tidiers.R
\name{tidy.coxphf}
\alias{tidy.coxphf}
\title{Tidy a coxphf object}
\usage{
tidy.coxphf(x, conf.int = FALSE, conf.level = 0.95, exponentiate = FALSE, ...)
}
\arguments{
\item{x}{A `coxphf` object.}

\item{conf.int}{Logical indicating whether or not to include 
a confidence interval in the tidied output. Defaults to FALSE.}

\item{conf.level}{The confidence level to use for the confidence 
interval if conf.int = TRUE. Must be strictly greater than 0 
and less than 1. Defaults to 0.95, which corresponds to a 
95 percent confidence interval.}

\item{exponentiate}{Logical indicating whether or not to display coefficient
estimates on an exponential scale.}

\item{...}{Unused, included for generic consistency only.}
}
\value{
A tidy [tibble::tibble()] summarizing component-level
  information about the model

import tibble
}
\description{
Tidy a coxphf object
}
