% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/PenLoglik.R
\name{LoglikPen}
\alias{LoglikPen}
\title{Compute the penalized log partial likelihood for a Cox PH model with MIC penalty}
\usage{
LoglikPen(beta, time, status, X, lambda, a)
}
\arguments{
\item{beta}{A p-dimensional vector containing the regression ceofficients in the CoxPH model.}

\item{time}{The observed survival time.}

\item{status}{The status indicator: 1 for event and 0 for censoring.}

\item{X}{An \eqn{n} by \eqn{p} design matrix.}

\item{lambda}{The penalty parameter euqals either 2 in AIC or ln(n0) in BIC (by default), where n0 is the number
of uncensored survival times observed in the data. You can also specify it to a specific value of your own choice.}

\item{a}{The scale parameter in the hyperbolic tangent function of the MIC penalty. By default, \eqn{a = n0}, i.e., the number
of uncensored survival times observed in the data.}
}
\value{
The value of the penalized log partial likelihood function evaluated at beta.
}
\description{
Compute the penalized log partial likelihood for a Cox PH model with MIC penalty
}
\references{
\itemize{
\item Abdolyousefi, R. N. and Su, X. (2016). \bold{coxphMIC}: An R package for sparse estimation of Cox PH Models via approximated information criterion. Tentatively accepted, \emph{The R Journal}.
\item Su, X. (2015). Variable selection via subtle uprooting.
\emph{Journal of Computational and Graphical Statistics}, \bold{24}(4): 1092--1113.
URL \url{http://www.tandfonline.com/doi/pdf/10.1080/10618600.2014.955176}
\item Su, X., Wijayasinghe, C. S., Fan, J., and Zhang, Y. (2015). Sparse estimation of Cox proportional
hazards models via approximated information criteria. \emph{Biometrics}, \bold{72}(3): 751--759.
URL \url{http://onlinelibrary.wiley.com/doi/10.1111/biom.12484/epdf}
}
}
\seealso{
\code{\link{coxph}}
}
