% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/read_datos_abiertos.R
\encoding{UTF-8}
\name{read_datos_abiertos}
\alias{read_datos_abiertos}
\title{Lee la base de datos de la direccion general de epidemiologia que ya descargaste}
\usage{
read_datos_abiertos(
  datos_abiertos_path = NULL,
  dbdir = tempfile(fileext = ".duckdb"),
  tblname = "covidmx",
  pragma_memory_limit = Sys.getenv("pragma_memory_limit"),
  drv = duckdb::duckdb(),
  colClasses = get_col_class(),
  read_format = c("duckdb", "tibble"),
  ...
)
}
\arguments{
\item{datos_abiertos_path}{(\strong{obligatorio}) Camino a los datos abiertos si son un \code{zip},
un \code{csv} o un \code{.duckdb}}

\item{dbdir}{(\strong{opcional}) Direccion donde guardar la base de datos con terminacion \code{.duckdb}.
Corresponde al argumento de \code{\link[duckdb:duckdb]{duckdb::dbConnect__duckdb_driver()}}}

\item{tblname}{(\strong{opcional})  Nombre de la tabla de \code{duckdb} donde guardar los datos por
default se llama \code{covidmx}. Solo es relevante si estas usando el mismo \code{dbdir} para otro
proyecto distinto.}

\item{pragma_memory_limit}{(\strong{opcional}) Limite de memoria para el programa
(ver \href{https://duckdb.org/docs/sql/pragmas}{PRAGMAS}). Cambialo a que sea mas o menos la mitad
de tu RAM. La forma mas sencilla es como una variable ambiental con
\code{Sys.setenv('pragma_memory_limit' = '1GB')} por ejemplo para un limite de 1 gigabyte.}

\item{drv}{(\strong{opcional}) Un  driver para \code{dbConnect} (default \code{duckdb::duckdb()})}

\item{colClasses}{(\strong{opcional}) Clases de la columna para leer en \code{duckdb::read_csv_duckdb()}.}

\item{read_format}{(\strong{opcional}) \code{"duckdb"} o \code{"tibble"} establece el formato
de lectura de la base de datos. En la mayoria de los casos \code{"tibble"} va a
resultar en un error de memoria. La opcion de \code{"duckdb"} siempre es mas rapida por lo cual
es el default.}

\item{...}{(\strong{opcional}) parametros adicionales para \code{\link[=descarga_datos_abiertos]{descarga_datos_abiertos()}}}
}
\value{
Lista de valores:
\itemize{
\item dats        - Tabla conectada mediante \code{DBI::dbConnect} (si \code{duckdb}) o
tibble (si \code{tibble})
\item disconnect  - Funcion para cerrar la conexion a la base de datos.
\item dict        - Lista de \code{tibble}s con el diccionario de datos para cada variable
}
}
\description{
\code{read_datos_abiertos} Lee los datos abiertos almacenados en tu base de \code{duckdb} que
bajaste con \code{descarga_datos_abiertos}. Intenta de manera automática determinar
si los lee de \code{duckdb}, \code{csv} ó \code{zip}
}
\note{
Para guardar tu base con \code{duckdb} cambia el \code{dbdir} a un archivo \code{.duckdb}. Como ejemplo
\code{dbdir = "ejemplo.duckdb"}.
}
\examples{
\donttest{
#Archivo temporal donde guardar las cosas es cualquier .duckdb
file_duck <- tempfile(fileext = ".duckdb")

#Estos links deben omitirse en una corrida normal. Se incluyen por ahora como ejemplo
#pero las opciones site.covid.dic y sites.covid deben eliminarse de abajo.
dlink   <- "https://github.com/RodrigoZepeda/covidmx/raw/main/datos_abiertos_covid19.zip"
diclink <- "https://github.com/RodrigoZepeda/covidmx/raw/main/diccionario_datos_covid19.zip"

if (RCurl::url.exists(dlink) & RCurl::url.exists(diclink)){
  # EJEMPLO 0: Descarga los datos abiertos en archivo file_duck
  descarga_datos_abiertos(dbdir = file_duck, sites.covid = dlink, show_warnings = FALSE, 
      site.covid.dic = diclink)$disconnect()

  # EJEMPLO 1: Lee los datos de duckdb una vez descargados
  datos_covid <- read_datos_abiertos(file_duck, show_warnings = FALSE, 
                                      site.covid.dic = diclink) # Lee duckdb
  datos_covid$disconnect()

# EJEMPLO 2: Lee los datos desde un zip descargado
# Descarga archivos de la DGE y guarda el zip
direccion_zip <- descarga_db_datos_abiertos_tbl(sites.covid = dlink, show_warnings = FALSE)
# Lee zip
datos_covid <- read_datos_abiertos(direccion_zip, dbdir = file_duck, show_warnings = FALSE,
                    site.covid.dic = diclink)
datos_covid$disconnect()

# EJEMPLO 3: Lee los datos desde un zip descargado
# Descarga archivos zip de la DGE
direccion_zip <- descarga_db_datos_abiertos_tbl(sites.covid = dlink, show_warnings = FALSE)
direccion_csv <- unzip_db_datos_abiertos_tbl(direccion_zip) # Descomprime el zip para tener csv
# Lee los csv
datos_covid <- read_datos_abiertos(direccion_csv, dbdir = file_duck, show_warnings = FALSE,
                                     site.covid.dic = diclink) 
datos_covid$disconnect()

# EJEMPLO 4: Si ya tenias el diccionario lo puedes agregar
# Simula la idea de ya tener el diccionario
diccionario <- descarga_diccionario(show_warnings = FALSE, site.covid.dic = diclink) 
datos_covid <- read_datos_abiertos(file_duck, diccionario = diccionario, show_warnings = FALSE)
datos_covid$disconnect()

# EJEMPLO 5: Si ya tenias el diccionario como archivo zip
# Descarga el diccionario para tenerlo como zip
diccionario_zip <- descarga_db_diccionario_ssa(show_warnings = FALSE, site.covid.dic = diclink) 
datos_covid <- read_datos_abiertos(file_duck, diccionario_zip_path = diccionario_zip, 
                                    show_warnings = FALSE)
datos_covid$disconnect()

# EJEMPLO 6: Si ya tenias el diccionario como archivo xlsx
# Descarga el diccionario para tenerlo como zip
diccionario_zip <- descarga_db_diccionario_ssa(show_warnings = FALSE, site.covid.dic = diclink)
# Abre el csv del diccionario
diccionario_csv <- unzip_db_diccionario_ssa(diccionario_zip) 
datos_covid <- read_datos_abiertos(file_duck,
  diccionario_unzipped_path = diccionario_csv,
  show_warnings = FALSE
)
datos_covid$disconnect()
}
}
}
\seealso{
\code{\link[=descarga_datos_abiertos]{descarga_datos_abiertos()}}  \code{\link[=descarga_datos_red_irag]{descarga_datos_red_irag()}}
\code{\link[=descarga_datos_variantes_GISAID]{descarga_datos_variantes_GISAID()}} \code{\link[=casos]{casos()}}
}
