% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/covid19_rollingEstimates.R
\name{estimateRRs}
\alias{estimateRRs}
\title{estimate rolling rates for a given geographical location for an specific TS data}
\usage{
estimateRRs(
  data = NULL,
  geo.loc = NULL,
  period = NULL,
  graphics.ON = TRUE,
  splitG = TRUE
)
}
\arguments{
\item{data}{time series dataset to consider}

\item{geo.loc}{country/region to analyze}

\item{period}{length of window}

\item{graphics.ON}{boolean flag to activate/deactivate graphical output}

\item{splitG}{boolean flag for having the graphical output separated or not}
}
\description{
estimate rolling rates for a given geographical location for an specific TS data
}
\examples{
# the following examples take longer than 10 sec, and triggers CRAN checks
\dontrun{
estimateRRs(covid19.data("TS-all"), geo.loc='Peru', period=7)
estimateRRs(covid19.data("TS-all"),
	geo.loc=c('Peru','Argentina','Uruguay','US','Spain','Japan'), period=7)
}

}
