% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/map_results.R
\name{map_flood}
\alias{map_flood}
\title{Function maps data, either by gage or by county}
\usage{
map_flood(flood_stats, category = "minor")
}
\arguments{
\item{flood_stats}{Either a data frame of flood analysis results, by gage or by county,
or a list of both data frames.}

\item{category}{Character string of the flood magnitude category to be used
for mapping (one of "minor", "moderate", "major", or "extreme"). This
parameter only works when mapping county-level, rather than gage-level,
values.}
}
\value{
A map of the state(s) analyzed showing counties and gages color coded
  based on flood magnitude, depending on the type of data in flood_stats. Gage
  flood thresholds are "None" (flood_ratio < 1), "Minor" (flood_ratio < 1.5),
  "Moderate" (flood_ratio < 2), "Major" (flood_ratio < 5), and "Extreme"
  (flood_ratio > 5). For county aggregate maps, flood exposure is assessed based
  on the percentage of gages in the county at or above a specified flood threshold.
  Exposure categories include "Low" (0% - 20%), "Moderate" (20% - 40%), "Moderate-High"
  (40% - 60%), "High" (60% - 80%), and "very High" (80% - 100%).
}
\description{
Displays a state or multi-state map summarizing flood analysis results either
by gage or county.
}
\examples{
\dontrun{
#Use Q2 as flood threshold and get get gage-level output
va_floods <- run_flood(state = "Virginia", start_date = "2015-01-01",
                      end_date = "2015-12-31", threshold = "Q2", output = "gage")
#Map results by gage
map_flood(va_floods)


#Use NWS flood thresholds and get county-level output
va_floods <- run_flood(state = "Virginia", start_date = "2015-01-01",
                      end_date = "2015-12-31", threshold = "NWS", flood_type = "action",
                      output = "county")
#Map results by county
map_flood(va_floods)
}
}
