% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/guess_field.R
\name{guess_field}
\alias{guess_field}
\title{Guess the code/name of a vector}
\usage{
guess_field(codes, min_similarity = 80)
}
\arguments{
\item{codes}{a vector of country codes or country names}

\item{min_similarity}{the function returns all field names where over than
\code{min_similarity}\% of codes are shared between the supplied vector and the
\code{countrycode} dictionary.}
}
\description{
Users sometimes do not know what kind of code or field their data contain.
This function tries to guess by comparing the similarity between a
user-supplied vector and all the codes included in the \code{countrycode}
dictionary.
}
\examples{
# Guess ISO codes
guess_field(c('DZA', 'CAN', 'DEU'))

# Guess country names
guess_field(c('Guinea','Iran','Russia','North Korea',rep('Ivory Coast',50),'Scotland'))
}
