% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/countland_subsample.R
\name{Subsample}
\alias{Subsample}
\title{Subsample cells to a standard number of counts by randomly sampling observations without replacement.}
\usage{
Subsample(C, gene_counts = NA, cell_counts = NA)
}
\arguments{
\item{C}{countland object}

\item{gene_counts}{maximum total counts for genes}

\item{cell_counts}{sequencing depth for all cells, or "min" to use the minimum cell total}
}
\value{
countland object with slot \code{subsample}
}
\description{
Subsample cells to a standard number of counts by randomly sampling observations without replacement.
}
\examples{
gold_path <- system.file("testdata", package = "countland", mustWork = TRUE)
gold.data <- Seurat::Read10X(data.dir = gold_path)
C <- countland(gold.data)
C <- Subsample(C,gene_counts=250,cell_counts=100)
}
