% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/cosinor2.R
\name{ssections}
\alias{ssections}
\title{Serial Sections}
\usage{
ssections(data, time, period, interval, increment, na.action = na.omit,
  alpha = 0.05)
}
\arguments{
\item{data}{A data frame containing responses of subjects collected over time, with subjects in the rows and timepoints in the columns.}

\item{time}{A vector containing the times at which the data was collected.}

\item{period}{Duration of one cycle of rhythm.}

\item{interval}{Length of an interval (number of timepoints) on which cosinor analyses will be ran.}

\item{increment}{A number indicating for how much timepoints should the interval be displaced throughout the data. Note that the value of the increment cannot be higher than the value of the interval.}

\item{na.action}{Action to be performed on missing values. Defaults to \code{na.omit}.}

\item{alpha}{Significance level for calculating population cosinor parameters confidence intervals. Defaults to .05 (confidence intervals are 5\% risk intervals).}
}
\value{
Object of the \code{Serial sections} class containing the following objects:
 \item{\code{coefficients}}{Cosinor coefficients in each of the intervals.}
 \item{\code{emp.mean}}{Empirical mean of the data across all timepoints.}
 \item{\code{p-values}}{\emph{p}-values from the rhythm detection test in each interval.}
 \item{\code{cosinors}}{A list containing all cosinor objects calculated in each interval.}
 \item{\code{plots}}{Stacked plots showing the empirical data, cosinor parameters and their confidence intervals, p-values of the rhythm detection test and number of measurements across time.}
}
\description{
Performs serial section analysis of rhythmic data and fits non-stationary cosinor models.
}
\details{
Cornélissen (2014) describes procedures for rhythmometric analysis of non-stationary data. First, an interval of an user-specified length (\eqn{I}) is chosen and usual cosinor analysis (i.e. single cosinor or population-mean cosinor) is performed on the interval. The interval is then displaced throughout the data by an user-specified increment (\eqn{\Delta t}) and cosinor analysis is then performed on the new interval. Intervals can be overlapping (\eqn{\Delta t}<I) or non-overlapping (\eqn{\Delta t}=I). A rhythm detection test is also calculated in each interval. After values of cosinor parameters have been obtained for each interval, they and their confidence intervals can be plotted, along with the \emph{p}-values from the rhythm detection test.
}
\note{
The value of increment cannot be higher than the value of the interval.
}
\examples{
ssections(data = PANAS_november, time = PANAS_time, period = 7,
interval = 7, increment = 1)
}
\references{
Cornélissen, G. (2014). Cosinor-Based Rhythmometry. \emph{Theoretical Biology and Medical Modeling}, \emph{11}, Article 16.
}
