% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/predict.cosimmr_output.R
\name{predict.cosimmr_output}
\alias{predict.cosimmr_output}
\title{Predicts proportion of each source in a mixture, based on values provided for covariates}
\usage{
\method{predict}{cosimmr_output}(object, x_pred, n_output = 3600, ...)
}
\arguments{
\item{object}{An object of class \code{cosimmr_output} created via the 
function \code{\link{cosimmr_ffvb}}}

\item{x_pred}{A data.frame of covariate values that the user wishes
to predict source proportions for, provided in the same order that the 
original covariance matrix was. Important for this to be a data.frame otherwise 
numeric values can be set as characters and this causes incorrect calculations.}

\item{n_output}{the number of posterior samples to generate. Defaults to 3600.}

\item{...}{Other arguments (not used)}
}
\value{
object of class 'cosimmr_pred_out'
}
\description{
Predicts proportion of each source in a mixture, based on values provided for covariates
}
\examples{
\donttest{
## See the package vignette for a detailed run through of these 4 examples

# Data set 1: 10 obs on 2 isos, 4 sources, with tefs and concdep
data(geese_data_day1)
cov_1 = c(1,2,3,2,3,1,1,1,2)
simmr_1 <- with(
  geese_data_day1,
  cosimmr_load(
    formula = mixtures ~ cov_1,
    source_names = source_names,
    source_means = source_means,
    source_sds = source_sds,
    correction_means = correction_means,
    correction_sds = correction_sds,
    concentration_means = concentration_means
  )
)

# Plot
plot(simmr_1)

# Print
simmr_1

# FFVB run
simmr_1_out <- cosimmr_ffvb(simmr_1)

# Print it
print(simmr_1_out)


# Plot
plot(simmr_1_out, type = "isospace")
plot(simmr_1_out, type = "beta_histogram", cov_name = "cov_1")

x_pred = data.frame(cov_1 = c(1,5))

pred_array<-predict(simmr_1_out, x_pred)

}
}
\references{
Andrew C. Parnell, Donald L. Phillips, Stuart Bearhop, Brice X.
Semmens, Eric J. Ward, Jonathan W. Moore, Andrew L. Jackson, Jonathan Grey,
David J. Kelly, and Richard Inger. Bayesian stable isotope mixing models.
Environmetrics, 24(6):387–399, 2013.
}
\seealso{
\code{\link{cosimmr_load}} for creating objects suitable for this
function,  and
\code{\link{plot.cosimmr_output}} for plotting output.
}
\author{
Emma Govan <emmagovan@gmail.com> Andrew Parnell
}
