% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/corregp.r
\name{pcplot.corregp}
\alias{pcplot.corregp}
\alias{pcplot}
\title{Parallel Coordinate Plotting for Correspondence Regression}
\usage{
\method{pcplot}{corregp}(x, parm = "x", axes, add_ci = FALSE, cl = 0.95,
  nq = TRUE, col = "darkgrey", cex = par("cex"), font = par("font"),
  family = par("family"), lwd = par("lwd"), lty = par("lty"),
  lcol = col, psym = NULL, pcol = col, pcex = cex, ecol = "red",
  ewid = 1, etyp = 2, acol = "black", awid = 1, atyp = 1,
  acex = cex, afnt = font, adir = 1, add_scale = FALSE, main = NULL,
  sub = NULL, ...)

pcplot(x, ...)
}
\arguments{
\item{x}{The output of a call to \code{\link{corregp}} (i.e. an object of class "corregp").}

\item{parm}{The parameter for which to plot the coordinates. Can be either \code{"y"}, \code{"x"}, or any vector of term names in X, level names in X or
level names in Y. Defaults to \code{"x"}.}

\item{axes}{The axes to plot.}

\item{add_ci}{Logical specifying whether to include the confidence intervals. Defaults to \code{FALSE}.}

\item{cl}{The confidence level for the confidence intervals. Defaults to \code{0.95}.}

\item{nq}{Logical specifying whether to use a normal quantile (i.e. apply \code{\link[stats]{qnorm}}) in the computation of the confidence intervals.
Defaults to \code{TRUE}. If \code{FALSE}, then the confidence intervals are computed directly with the \code{\link[stats]{quantile}} function.}

\item{col}{Color of the text labels: either \code{numeric} or see \code{\link[grDevices]{colors}}.}

\item{cex}{Character expansion factor: a number to specify the size of the text labels.}

\item{font}{Font of the text labels: \code{1} for plain, \code{2} for bold, \code{3} for italic, and \code{4} for bold italic. Defaults to \code{1}.}

\item{family}{Font family of the text labels: can be \code{"serif"}, \code{"sans"}, \code{"mono"} or one of the \code{\link[grDevices]{Hershey}} fonts.}

\item{lwd}{Width of the connecting lines: a number to specify the line width.}

\item{lty}{Line type of the connecting lines: \code{0} or \code{"blank"}, \code{1} or \code{"solid"}, \code{2} or \code{"dashed"}, \code{3} or
\code{"dotted"}, \code{4} or \code{"dotdash"}, \code{5} or \code{"longdash"}, \code{6} or \code{"twodash"}. Defaults to \code{1}.}

\item{lcol}{Color of the connecting lines: either \code{numeric} or see \code{\link[grDevices]{colors}}.}

\item{psym}{The symbol (or "plotting character") for the values of the coordinates on the axes.}

\item{pcol}{Color of the symbol for the values on the axes: either \code{numeric} or see \code{\link[grDevices]{colors}}.}

\item{pcex}{Character expansion factor of the symbol for the values on the axes.}

\item{ecol}{Color of the error lines (connecting the confidence intervals on each axis): either \code{numeric} or see \code{\link[grDevices]{colors}}.}

\item{ewid}{Width of the error lines (connecting the confidence intervals on each axis): a number to specify the line width.}

\item{etyp}{Line type of the error lines (connecting the confidence intervals on each axis): \code{0} or \code{"blank"}, \code{1} or \code{"solid"},
\code{2} or \code{"dashed"}, \code{3} or \code{"dotted"}, \code{4} or \code{"dotdash"}, \code{5} or \code{"longdash"}, \code{6} or
\code{"twodash"}. Defaults to \code{2}.}

\item{acol}{Color of the parallel axes: either \code{numeric} or see \code{\link[grDevices]{colors}}.}

\item{awid}{Width of the parallel axes: a number to specify the line width.}

\item{atyp}{Line type of the parallel axes: \code{0} or \code{"blank"}, \code{1} or \code{"solid"}, \code{2} or \code{"dashed"}, \code{3} or
\code{"dotted"}, \code{4} or \code{"dotdash"}, \code{5} or \code{"longdash"}, \code{6} or \code{"twodash"}. Defaults to \code{1}.}

\item{acex}{Character expansion factor for the labels of the parallel axes.}

\item{afnt}{Font for the labels of the parallel axes: \code{1} for plain, \code{2} for bold, \code{3} for italic, and \code{4} for bold italic.}

\item{adir}{Reading direction of the labels on the parallel axes: either a \code{numeric} value between \code{0} and \code{3} (see the \code{las}
argument in the graphical parameters \code{\link[graphics]{par}}) or a \code{character} value matching either \code{"horizontal"} or
\code{"vertical"}. Defaults to \code{1} (horizontal).}

\item{add_scale}{Logical specifying whether to add a scale for the parallel axes (which are normalised).}

\item{main}{The main title of the plot.}

\item{sub}{The subtitle of the plot.}

\item{...}{Further arguments passed to or from other methods.}
}
\value{
A parallel coordinate plot containing the output of a correspondence regression.
}
\description{
Method to produce a \emph{parallel coordinate plot} of the output of a correspondence regression.
}
\details{
Although adding lines for confidence intervals is possible, it is not recommended, as it typically leads to an unreadable plot.
}
\examples{
\donttest{
data(HairEye)
haireye.crg <- corregp(Eye ~ Hair * Sex, data = HairEye, b = 3000)
pcplot(haireye.crg, parm = "y", axes = 1:3)
pcplot(haireye.crg, parm = c("Hair", "Sex"), axes = 1:3)
}
}
\seealso{
\code{\link{ciplot.corregp}}, \code{\link{plot.corregp}}, \code{\link{plot3d.corregp}}, \code{\link{agplot.corregp}}.
}
