% Generated by roxygen2 (4.0.2): do not edit by hand
\name{cell.corregp}
\alias{cell}
\alias{cell.corregp}
\title{Confidence Ellipses for Correspondence Regression}
\usage{
\method{cell}{corregp}(object, parm = "x", axes = 1:2, cl = 0.95,
  np = 100, ...)

cell(object, ...)
}
\arguments{
\item{object}{The output of a call to \code{\link{corregp}} (i.e. an object of class "corregp").}

\item{parm}{The parameter for which to compute the confidence ellipses. Can be either \code{"y"}, \code{"x"}, or any vector of term names in X, level names in X or
level names in Y. Defaults to \code{"x"}.}

\item{axes}{The axes for which to compute the confidence ellipses: a vector of two values. Defaults to the first two axes.}

\item{cl}{The confidence level for the confidence ellipses. Defaults to \code{0.95}.}

\item{np}{The number of points to represent the confidence ellipses. Defaults to \code{100}.}

\item{...}{Further arguments passed to or from other methods.}
}
\value{
A list containing \code{np} points for each confidence ellipse of interest.
}
\description{
Method to compute confidence ellipses for coordinates in correspondence regression.
}
\details{
\code{cell} (of a \code{corregp} output) makes use of \code{\link[ellipse]{ellipse}} from the package \pkg{ellipse}.

Typically, \code{cell} is not so much used directly as it is called by a \code{\link{plot.corregp}} command.
}
\examples{
data(HairEye)
haireye.crg <- corregp(Eye ~ Hair * Sex, data = HairEye, b = 3000)
cell(haireye.crg, parm = "y")
cell(haireye.crg, parm = c("Hair", "Sex"))
}
\seealso{
\code{\link{plot.corregp}}.
}

