% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/posterior_prob_functions.R
\name{approx.bf.p}
\alias{approx.bf.p}
\title{Find approx. Bayes factors (ABFs)}
\usage{
approx.bf.p(pvals, f, type, N, s, W = 0.2)
}
\arguments{
\item{pvals}{P-values}

\item{f}{Minor allele frequencies}

\item{type}{Type of experiment ('quant' or 'cc')}

\item{N}{Total sample size}

\item{s}{Proportion of cases (N1/N0+N1), ignored if type=='quant'}

\item{W}{Prior for the standard deviation of the effect size parameter beta (W=0.2 default)}
}
\value{
data.frame containing lABF and intermediate calculations
}
\description{
Wakefield's log asymptotic Bayes factor (lABF) with prior standard deviation of effect size as a parameter
}
\details{
([Wakefield et al. 2009](https://onlinelibrary.wiley.com/doi/abs/10.1002/gepi.20359)
This function converts p-values to log ABFs, also reporting intermediate calculations
}
\examples{

set.seed(1)
nsnps = 100
N0 = 5000
N1 = 5000
z_scores <- rnorm(nsnps, 0, 3)
p_values <- 2 * pnorm( - abs ( z_scores ) )

## generate example LD matrix and MAFs
library(mvtnorm)
nsamples = 1000

simx <- function(nsnps, nsamples, S, maf=0.1) {
    mu <- rep(0,nsnps)
    rawvars <- rmvnorm(n=nsamples, mean=mu, sigma=S)
    pvars <- pnorm(rawvars)
    x <- qbinom(1-pvars, 1, maf)
}

S <- (1 - (abs(outer(1:nsnps,1:nsnps,`-`))/nsnps))^4
X <- simx(nsnps,nsamples,S)
maf <- colMeans(X)

approx.bf.p(pvals = p_values, f = maf, type = "cc", N = N0+N1, s = N1/(N0+N1))

}
