% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/differentialTest.R
\name{differentialTest}
\alias{differentialTest}
\title{Identify differentially-abundant and differentially-variable taxa}
\usage{
differentialTest(
  formula,
  phi.formula,
  formula_null,
  phi.formula_null,
  data,
  link = "logit",
  phi.link = "logit",
  test,
  boot = FALSE,
  B = 1000,
  sample_data = NULL,
  taxa_are_rows = TRUE,
  filter_discriminant = TRUE,
  fdr_cutoff = 0.05,
  fdr = "fdr",
  full_output = FALSE,
  inits = NULL,
  inits_null = NULL,
  try_only = NULL,
  ...
)
}
\arguments{
\item{formula}{an object of class \code{formula} without the response: a symbolic description of the model to be fitted to the abundance}

\item{phi.formula}{an object of class \code{formula} without the response: a symbolic description of the model to be fitted to the dispersion}

\item{formula_null}{Formula for mean under null, without response}

\item{phi.formula_null}{Formula for overdispersion under null, without response}

\item{data}{a data frame containing the OTU table, or \code{phyloseq} object containing the variables in the models}

\item{link}{link function for abundance covariates, defaults to \code{"logit"}}

\item{phi.link}{link function for dispersion covariates, defaults to \code{"logit"}}

\item{test}{Character. Hypothesis testing procedure to use. One of \code{"Wald"} or \code{"LRT"} (likelihood ratio test).}

\item{boot}{Boolean. Defaults to \code{FALSE}. Indicator of whether or not to use parametric bootstrap algorithm. (See \code{\link{pbWald}} and \code{\link{pbLRT}}).}

\item{B}{Optional integer. Number of bootstrap iterations. Ignored if \code{boot} is \code{FALSE}. Otherwise, defaults to \code{1000}.}

\item{sample_data}{Data frame or matrix. Defaults to \code{NULL}. If \code{data} is a data frame or matrix, this must be included as covariates/sample data.}

\item{taxa_are_rows}{Boolean. Optional. If \code{data} is a data frame or matrix, this indicates whether taxa are rows. Defaults to \code{TRUE}.}

\item{filter_discriminant}{Boolean. Defaults to \code{TRUE}. If \code{FALSE}, discriminant taxa will not be filtered out.}

\item{fdr_cutoff}{Integer. Defaults to \code{0.05}. Desired type 1 error rate}

\item{fdr}{Character. Defaults to \code{"fdr"}. False discovery rate control method, see \code{\link{p.adjust}} for more options.}

\item{full_output}{Boolean. Opetional. Defaults to \code{FALSE}. Indicator of whether to include full \code{bbdml} model output for all taxa.}

\item{inits}{Optional initializations for model fit using \code{formula} and \code{phi.formula} as rows of a matrix. Defaults to \code{NULL}.}

\item{inits_null}{Optional initializations for model fit using \code{formula_null} and \code{phi.formula_null} as rows of a matrix. Defaults to \code{NULL}.}

\item{try_only}{Optional numeric. Will try only the \code{try_only} taxa, specified either via numeric input or character taxa names. Useful for speed when troubleshooting. Defaults to \code{NULL}, testing all taxa.}

\item{...}{Optional additional arguments for \code{\link{bbdml}}}
}
\value{
An object of class \code{differentialTest}. List with elements \code{p} containing the p-values, \code{p_fdr} containing the p-values after false discovery rate control,  \code{significant_taxa} containing the taxa names of the statistically significant taxa, \code{significant_models} containing a list of the model fits for the significant taxa, \code{all_models} containing a list of the model fits for all taxa, \code{restrictions_DA} containing a list of covariates that were tested for differential abundance, \code{restrictions_DV} containing a list of covariates that were tested for differential variability, \code{discriminant_taxa_DA} containing the taxa for which at least one covariate associated with the abundance was perfectly discriminant, \code{discriminant_taxa_DV} containing the taxa for which at least one covariate associated with the dispersion was perfectly discriminant, \code{data} containing the data used to fit the models. If \code{full_output = TRUE}, it will also include \code{full_output}, a list of all model output from \code{bbdml}.
}
\description{
Identify differentially-abundant and differentially-variable taxa
}
\details{
See package vignette for details and example usage. Make sure the number of columns in all of the initializations are correct! \code{inits} probably shouldn't match \code{inits_null}. To use a contrast matrix, see \code{\link{contrastsTest}}.
}
\examples{
# phyloseq example
data(soil_phylum_small)
da_analysis <- differentialTest(formula = ~ DayAmdmt,
                                phi.formula = ~ DayAmdmt,
                                formula_null = ~ 1,
                                phi.formula_null = ~ DayAmdmt,
                                test = "Wald", boot = FALSE,
                                data = soil_phylum_small,
                                fdr_cutoff = 0.05)
}
