% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/copstressMin.R
\name{copstressMin}
\alias{copstressMin}
\alias{copsc}
\alias{copStressMin}
\title{Fitting a COPS-C Model (COPS Variant 1).}
\usage{
copstressMin(
  delta,
  kappa = 1,
  lambda = 1,
  nu = 1,
  theta = c(kappa, lambda, nu),
  type = c("ratio", "interval", "ordinal"),
  ties = "primary",
  weightmat = 1 - diag(nrow(delta)),
  ndim = 2,
  init = NULL,
  stressweight = 0.975,
  cordweight = 0.025,
  q = 1,
  minpts = ndim + 1,
  epsilon = max(10, max(delta)),
  dmax = NULL,
  rang,
  optimmethod = c("NelderMead", "Newuoa", "BFGS", "SANN", "hjk", "solnl", "solnp",
    "subplex", "snomadr", "hjk-Newuoa", "hjk-BFGS", "BFGS-hjk", "Newuoa-hjk", "cmaes",
    "direct", "direct-Newuoa", "direct-BFGS", "genoud", "gensa"),
  verbose = 0,
  scale = c("sd", "rmsq", "proc", "none"),
  normed = TRUE,
  accuracy = 1e-07,
  itmax = 10000,
  stresstype = c("stress-1", "stress"),
  principal = FALSE,
  ...
)

copsc(
  delta,
  kappa = 1,
  lambda = 1,
  nu = 1,
  theta = c(kappa, lambda, nu),
  type = c("ratio", "interval", "ordinal"),
  ties = "primary",
  weightmat = 1 - diag(nrow(delta)),
  ndim = 2,
  init = NULL,
  stressweight = 0.975,
  cordweight = 0.025,
  q = 1,
  minpts = ndim + 1,
  epsilon = max(10, max(delta)),
  dmax = NULL,
  rang,
  optimmethod = c("NelderMead", "Newuoa", "BFGS", "SANN", "hjk", "solnl", "solnp",
    "subplex", "snomadr", "hjk-Newuoa", "hjk-BFGS", "BFGS-hjk", "Newuoa-hjk", "cmaes",
    "direct", "direct-Newuoa", "direct-BFGS", "genoud", "gensa"),
  verbose = 0,
  scale = c("sd", "rmsq", "proc", "none"),
  normed = TRUE,
  accuracy = 1e-07,
  itmax = 10000,
  stresstype = c("stress-1", "stress"),
  principal = FALSE,
  ...
)

copStressMin(
  delta,
  kappa = 1,
  lambda = 1,
  nu = 1,
  theta = c(kappa, lambda, nu),
  type = c("ratio", "interval", "ordinal"),
  ties = "primary",
  weightmat = 1 - diag(nrow(delta)),
  ndim = 2,
  init = NULL,
  stressweight = 0.975,
  cordweight = 0.025,
  q = 1,
  minpts = ndim + 1,
  epsilon = max(10, max(delta)),
  dmax = NULL,
  rang,
  optimmethod = c("NelderMead", "Newuoa", "BFGS", "SANN", "hjk", "solnl", "solnp",
    "subplex", "snomadr", "hjk-Newuoa", "hjk-BFGS", "BFGS-hjk", "Newuoa-hjk", "cmaes",
    "direct", "direct-Newuoa", "direct-BFGS", "genoud", "gensa"),
  verbose = 0,
  scale = c("sd", "rmsq", "proc", "none"),
  normed = TRUE,
  accuracy = 1e-07,
  itmax = 10000,
  stresstype = c("stress-1", "stress"),
  principal = FALSE,
  ...
)
}
\arguments{
\item{delta}{numeric matrix or dist object of a matrix of proximities}

\item{kappa}{power transformation for fitted distances}

\item{lambda}{power transformation for proximities (only used if type="ratio" or "interval")}

\item{nu}{power transformation for weights}

\item{theta}{the theta vector of powers; the first is kappa (for the fitted distances if it exists), the second lambda (for the observed proximities if it exist and type="ratio" or "interval"), the third is nu (for the weights if it exists). If less than three elements are is given as argument, it will be recycled. Defaults to 1 1 1. Will override any kappa, lambda, nu parameters if they are given and do not match.}

\item{type}{what type of MDS to fit. Currently one of "ratio", "interval" or "ordinal". Default is "ratio".}

\item{ties}{the handling of ties for ordinal (nonmetric) MDS. Possible are "primary" (default), "secondary" or "tertiary".}

\item{weightmat}{(optional) a matrix of nonnegative weights; defaults to 1 for all off diagonals}

\item{ndim}{number of dimensions of the target space}

\item{init}{(optional) initial configuration}

\item{stressweight}{weight to be used for the fit measure; defaults to 0.975}

\item{cordweight}{weight to be used for the cordillera; defaults to 0.025}

\item{q}{the norm of the cordillera; defaults to 1}

\item{minpts}{the minimum points to make up a cluster in OPTICS, see \code{\link[dbscan]{optics}} where it is called \code{minPts}; defaults to ndim+1.}

\item{epsilon}{the epsilon parameter of OPTICS, the neighbourhood that is checked, see \code{\link[dbscan]{optics}}; defaults to 10 (which is plenty for the explicit normalization we use). Note this means we do not expect any noise objects per default. This number will rarely be exceeded if we standardize the configuration as is the default in cops. However if no standardization is applied or there is a procrustes adjustment to a configuration with variance of 10 or more on any of the axes, it can have the effect of being too small. In that case just set a much higher epsilon.}

\item{dmax}{The winsorization limit of reachability distances in the OPTICS Cordillera. If supplied, it should be either a numeric value that matches 'max(rang)' or 'NULL'; if 'NULL' it is found as 1.5 times (for kappa >1) or 1 times (for kappa <=1) the maximum reachbility value of the power torgerson model with the same lambda. If 'dmax' and 'rang' are supplied and 'dmax' is not 'max(rang)', a warning is given and 'rang' takes precedence.}

\item{rang}{range of the reachabilities to be considered. If missing it is found from the initial configuration by taking 0 as the lower boundary and dmax (see above) as upper boundary. See also \code{\link[cordillera]{cordillera}}}

\item{optimmethod}{What optimizer to use? Choose one string of 'Newuoa' (\code{\link[minqa]{newuoa}}), 'NelderMead' (see \code{\link[stats]{optim}}), 'hjk' (Hooke-Jeeves algorithm from \code{\link[dfoptim]{hjk}}), 'solnl' (from \code{\link[NlcOptim]{solnl}}), 'solnp' (from \code{\link[Rsolnp]{solnp}}), 'subplex' (from \code{\link[subplex]{subplex}}), 'SANN' (simulated annealing, \code{\link[stats]{optim}}), 'BFGS' (see \code{\link[stats]{optim}}), 'snomadr' (from \code{\link[crs]{snomadr}}), 'genoud' (from \code{\link[rgenoud]{genoud}}), 'gensa' (from \code{\link[GenSA]{GenSA}}), 'cmaes' (from \code{\link[cmaes]{cma_es}}) and 'direct' (from \code{\link[nloptr]{direct}}). See the linked functions for details on these solvers. There are also combinations that proved to work well good, like 'hjk-Newuoa', 'hjk-BFGS', 'BFGS-hjk', 'Newuoa-hjk', 'direct-Newuoa' and 'direct-BFGS'. Usually everything with 'hjk', 'BFGS', 'Newuoa', 'subplex' and 'solnl' in it work rather well in an acceptable time frame (depending on the smoothness of copstress). Default is 'hjk-Newuoa'.}

\item{verbose}{numeric value hat prints information on the fitting process; >2 is very verbose}

\item{scale}{Scale the configuration (in MDS stress is invariant up to a scaling factor). One of "none" (so no extra scaling of the configuration but normalized to sum delta^2=1), "sd" (configuration divided by the highest standard deviation of any the columns), "proc" (procrustes adjustment to the initial fit) and "rmsq" (configuration divided by the maximum root mean square of the columns). Default is "sd" which often gives a nicer spread on the axes. Note that the scaled configuration is returned as $conf and the unscaled as $usconf, so manual calculation of the OC should be done with $conf.}

\item{normed}{should the Cordillera be normed; defaults to TRUE.}

\item{accuracy}{numerical accuracy, defaults to 1e-7.}

\item{itmax}{maximum number of iterations. Defaults to 10000. For the two-step algorithms if itmax is exceeded by the first solver, the second algorithm is run for at least 0.1*itmax (so overall itmax may be exceeded by a factor of 1.1).}

\item{stresstype}{which stress to use in the copstress. Defaults to stress-1. If anything else is set, explicitly normed stress which is (stress-1)^2 is used. Using stress-1 puts more weight on MDS fit.}

\item{principal}{If ‘TRUE’, principal axis transformation is applied to the final configuration.}

\item{...}{additional arguments to be passed to the optimization procedure}
}
\value{
A copsc object (inheriting from smacofP). A list with the components
        \itemize{
        \item delta: the original untransformed dissimilarities
        \item tdelta: the explicitly transformed dissimilarities 
        \item dhat: the explicitly transformed dissimilarities (dhats), optimally scaled and normalized (which are approximated by the fit)
        \item confdist: Configuration distances, the fitted distances
        \item conf: the configuration (normed) and scaled as specified in scale. 
        \item usconf: the unscaled configuration (normed to sum delta^2=1). Scaling applied to usconf gives conf.
        \item parameters, par, pars : the theta vector of powers tranformations (kappa, lambda, nu)
        \item niter: number of iterations of the optimizer. 
        \item stress: the square root of explicitly normalized stress (calculated for confo).
        \item spp: stress per point
        \item ndim: number of dimensions
        \item model: Fitted model name
        \item call: the call
        \item nobj: the number of objects
        \item type, loss, losstype: stresstype
        \item stress.m: The stress used for copstress. If stresstype="stress-1" this is like $stress else it is stress^2
        \item copstress: the copstress loss value
        \item resmat: the matrix of residuals
        \item weightmat: the matrix of untransformed weights
        \item tweightmat: the transformed weighting matrix (here weightmat^nu) 
        \item OC: the (normed) OPTICS Cordillera object (calculated for scaled conf)
        \item OCv: the (normed) OPTICS Cordillera value alone (calculated for scaled conf)
        \item optim: the object returned from the optimization procedure
        \item stressweight, cordweight: the weights of the stress and OC respectively (v_1 and v_2)
        \item optimmethod: The solver used 
        \item type: the type of MDS fitted
}
}
\description{
Minimizing Copstress to obtain a clustered ratio, interval or ordinal PS configuration with given explicit power transformations theta. The function allows mix-and-match of explicit (via theta) and implicit (via type) transformations by setting the kappa, lambda, nu (or theta) and type arguments.
}
\details{
This is an extremely flexible approach to least squares proximity scaling: It supports ratio power stress; ratio, interval and ordinal r stress and ratio, interval and ordinal MDS with or without a COPS penalty. Famous special cases of these models that can be fitted are multiscale MDS if kappa->0 and delta=log(delta), Alscal MDS (sstress) with lambda=kappa=2, sammon type mapping with weightmat=delta and nu=-1, elastic scaling with weightmat=delta and nu=-2. Due to mix-and-match this function also allows to fit models that have not yet been published, such as for example an "elastic scaling ordinal s-stress with cops penalty".

If one wants to fit these models without the cops penalty, we recommend to use \code{\link[smacofx]{powerStressMin}} (for ratio and interval MDS with any power transformation for weights, dissimilarities and distances) or \code{\link[smacofx]{rStressMin}} (for ratio, interval and ordinal MDS with power transformations for distances and weights) as these use majorization.


Some optimizers (including the default hjk-Newuoa) will print a warning if itmax is (too) small or if there was no convergence. Consider increasing itmax then.

For some solvers theresometimes may be an error [NA/NaN/Inf in foreign function call (arg 3)] stemming from smacof::transform(). This happens when the algorithm places two object at exactly the same place so their fitted distance is 0. This is good from an OPTICS Cordillera point of view (as it is more clustered) which is why some solvers like to pick that up, but it can lead to an issue in the optimal scaling in smacof. This can usually be mitigated when specifying the model by either using less cordweight, less itmax, less accuracy or combining the two offending objects into one (so include them as a combined row in the distance matrix).

We might eventually switch to newuoa in nloptr.
}
\examples{
dis<-as.matrix(smacof::kinshipdelta)

set.seed(1)
## Copstress with equal weight to stress and cordillera 
res1<-copstressMin(dis,stressweight=0.5,cordweight=0.5,
                  itmax=100) #use higher itmax about 10000 
res1
summary(res1)
plot(res1)  #super clustered 

##Alias name 
res1<-copsc(dis,stressweight=0.5,
                  cordweight=0.5,itmax=100) 


## Elastic scaling ordinal s-stress with cops penalty
res1<-copsc(dis,type="ordinal",kappa=2,nu=-2,weightmat=dis,
            stressweight=0.5, cordweight=0.5,itmax=100)


}
\keyword{clustering}
\keyword{multivariate}
