% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/probafix.R
\name{probafix}
\alias{probafix}
\title{Probabitility of event when the follow-up is fixed}
\usage{
probafix(surv,time,duraccrual,durfollow,limit,gamma)
}
\arguments{
\item{surv}{Survival estimates}

\item{time}{Time estimate}

\item{duraccrual}{Accrual duration, expressed in t time units}

\item{durfollow}{Follow-up duration}

\item{limit}{Time limit to estimate the survival probability}

\item{gamma}{the probability of observing an event by time t}
}
\value{
probafix: event probability at time limit
}
\description{
In a fixed follow-up design, each subject can only be followed during a fixed period (Tf < infinite) 
and then goes off study. Using similar reasoning to K. Kim and A.A. Tsiatis (1990), it is easy to compute the probability.
}
\details{
The probafix function estimates the probability of event when the follow-up is fixed.
}
\references{
K. Kim, A.A. Tsiatis, Study duration for clinical trials with survival response and early stopping rule, Biometrics 46 (1990) 81-92
}

