% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/datacheck.R
\name{datacheck}
\alias{datacheck}
\title{check the consistency of the parameters}
\usage{
datacheck(design,Survhyp,pe,alfa,beta,duraccrual,durstudy,look,followup,dropout)
}
\arguments{
\item{design}{Superiority=c(1,sided)[with sided=1 if 1-sided and 2 if 2-sided]; Non inferiority=c(2); Equivalence=c(3)}

\item{Survhyp}{For Superiority=c(thyp,t,hype,Sc); for Non inferiority=c(thyp,t,hype,Sc,hypeA); for Equivalence=c(t,delta,Sc): parameters at time t 
if thyp=1 then hype is survival rate in experimental arm under the null hypothesis and hypeA is the survival rate in the experimental arm under the alternative hypothesis; 
if thyp=2 then hype is the hazard ratio under the null hypothesis and hypeA is the hazard ratio under the alternative hypothesis; Sc is the survival rate in the control arm; 
delta is the log hazard ratio equivalence margin. When endpoint is HRQoL, the survival rate is replaced by the rate of patients without the HRQoL deterioration.}

\item{pe}{Proportion (ratio) of patients assigned to the experimental arm (with 0<pe<1)}

\item{alfa}{Type I error, for Non inferiority, Equivalence and 1-sided superiority, alfa is a vector of length one. 
For 2-sided superiority, alfa is a vector to length two c(alpha.low, alpha.up).}

\item{beta}{Probability of a type II error.}

\item{duraccrual}{Accrual duration, expressed in number of days, months or years}

\item{durstudy}{Study duration, expressed in number of days, months or years}

\item{look}{The number interim analyses, c(1) for one final analysis; c(nb, bound, timing) for at least one interim analyses with bound=c(bound.eff,bound.fut):1-sided or bound=c(bound.low,bound.up):2-sided.
nb the number of planned looks, bound.eff and bound.fut corresponds to the type of boundaries used for efficacy (i.e. reject H0) and futility (i.e. reject H1). 
bound.fut=0: No futility monitoring, 1: Lan deMets O.Brien Fleming, 2: Lan deMets Pocock. 
bound.low and bound.up the type of lower and upper boundaries used (1: Lan deMets O.Brien Fleming, 2: Lan deMets Pocock, 3: O.Brien Fleming, 4: Pocock). Default value = 1.}

\item{followup}{Follow-up information, No fixed:c(0) (follow-up until the end of study); 
Fixed:c(1, durfollow) with durfollow is the duration of follow-up}

\item{dropout}{Drop out information, No drop out:c(0); Drop out:c(1,gammae,gammac) with gammae the hazard drop out rates in experimental arm and control arm respectively.}
}
\description{
this function check the parameters required to calcul the sample size for nsurvival and ncoprimary functions. 
datacheck is a simple utility for carrying out parameter checks and reporting on problems or errors.
}
\details{
the datacheck function performs consistency checks on the arguments
}

