% Generated by roxygen2 (4.0.2): do not edit by hand
\name{ComputeCope}
\alias{ComputeCope}
\title{Compute CoPE sets.}
\usage{
ComputeCope(Z, level, X = NULL, tau = 1/sqrt(dim(Z$z)[3]), alpha = 0.1,
  N = 1000, mu = NULL, mask = NULL)
}
\arguments{
\item{Z}{A list with components "x", "y" and "z". Here, x and y are the
coordinates of the grid on which the data is observed and z is an
array with dimensions c(length(x),length(y),n), containing the
data. n is the number of observations.}

\item{level}{The level of interest.}

\item{X}{The design matrix of the linear model. If NULL, it is set to
matrix(rep(1,dim(Y)[3]),ncol=1) corresponding to i.i.d. data.}

\item{tau}{The scaling factor ||v||_2*pi_n^(1/2). The default 1/sqrt(n)
corresponds to i.i.d. data.}

\item{alpha}{The significance level. Inclusion for CoPE sets holds with
probability 1-alpha.}

\item{N}{The number of bootstrap realizations to generate for determining
the threshold.}

\item{mu}{The true parameter function. Use the default NULL if unknown.}

\item{mask}{Pixels outside the mask (i.e. where mask is ==NA) are ignored.}
}
\value{
An object of class cope. A list containing the following
\itemize{
 \item{x, y: }{The grid coordinates from the input.}
 \item{mu, level, tau, X, N, alpha, mask: }
 {The corresponding values from the input.}
 \item{mu_hat, norm_est: }{The estimatot for mu and its normalized version.}
 \item{a_MB, a_MB_true, a_Tay, a_Tay_true: }{Thresholds for the CoPE sets
 determined using the multiplier bootstrap or Taylor's method and the
 estimated or the true contour, respectively.}
 \item{incl_MB, incl_MB_true, incl_Tay, incl_Tay_true: }{Booleans indicating
 whether inclusion of the excursion set in the upper CoPE set and inclusion
 of the lower CoPE set in the excursion set holds, when CoPE sets are
 determined by a_MB, a_MB_true, a_Tay or a_Tay_true, respectively. Only
 available if mu is given.}
}
}
\description{
Computes CoPE sets for the data Y using the algorithm from Sommerfeld, Sain
and Schwartzman (2015).
}
\examples{
# An example using the ToyNoise and ToySignal of this package.
n = 30
Data = ToyNoise1(n = n)
Data$z = Data$z + rep(ToySignal()$z, n)
CopeSet = ComputeCope(Data,level=4/3, mu=ToySignal()$z)
PlotCope(CopeSet)
}
\references{
M. Sommerfeld, S. Sain and A. Schwartzman. Confidence regions for
            excursion sets in asymptotically Gaussian
            random fields, with an application to climate. Preprint, 2015.
}

