% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/subplot.R
\name{subplot}
\alias{subplot}
\title{Insert a sub-panel into plot}
\usage{
subplot(xleft = NA, ybottom, xright, ytop)
}
\arguments{
\item{xleft}{lower x-coordinate of the sub-panel relative to the current plot.}

\item{ybottom}{lower y-coordinate of the sub-panel relative to the current plot.}

\item{xright}{upper x-coordinate of the sub-panel relative to the current plot.}

\item{ytop}{upper y-coordinate of the sub-panel relative to the current plot.}
}
\value{
graphical parameters to user with \code{\link[graphics]{par}}.
}
\description{
Insert a sub-panel into an existing plotting area. To open a subplot, call \code{par(subplot(...))}, to close it, you must call \code{par(subplot('off'))}.
}
\examples{
# main plot
f = function(x) x*sin(1/(x+.Machine$double.eps))
curve(f,0,1,n=1000,ylim=c(-1,1),xlab='',ylab='',xaxs='i',yaxs='i')
rect(0.02,-0.1,0.1,0.1,border='blue',col=transparent('blue',0.2))

# subplot
par(subplot(0.55,-0.8,0.93,0))
curve(f,0.02,0.1,n=500,ylim=c(-0.1,0.1),xlab='',ylab='',xaxs='i',yaxs='i')
rect(0.02,-0.1,0.1,0.1,border=NA,col= transparent('blue',0.2))
par(subplot('off'))

}
\author{
Danail Obreschkow
}
