% Generated by roxygen2 (4.1.0): do not edit by hand
% Please edit documentation in R/convoSPAT_summplot.R
\name{plot_correlation}
\alias{plot_correlation}
\title{Plot estimated correlations.}
\usage{
plot_correlation(model.fit.obj, ref.loc, all.pred.locs, NS.model = TRUE,
  grid = TRUE)
}
\arguments{
\item{model.fit.obj}{The object which is the output of either
\code{NSconvo.fit} or \code{Aniso.fit}.}

\item{ref.loc}{Vector of length 2; the reference location.}

\item{all.pred.locs}{A matrix of all prediction locations.}

\item{NS.model}{Logical; indicates if \code{model.fit.obj} is
from \code{NSconvo.fit} (\code{TRUE}) or \code{Aniso.fit}
(\code{FALSE}).}

\item{grid}{Logical; indicates if the \code{all.pred.locs}
are on a rectangular grid (\code{TRUE}) or not (\code{FALSE}).}
}
\value{
A plot of the estimated correlation is printed.
}
\description{
This function plots the estimated correlation over the spatial
domain between a reference point and all other prediction locations.
}
\examples{
\dontrun{
plot_correlation( model.fit.obj = fit.model, ref.loc = c(1.5, 3.5),
all.pred.locs = pred.locs, NS.model = TRUE )
}
}

