% Generated by roxygen2 (4.1.0): do not edit by hand
% Please edit documentation in R/findanc.R
\name{findanc}
\alias{findanc}
\title{Find the ancestor of a given node in a phylogeny}
\usage{
findanc(phyl, node)
}
\arguments{
\item{phyl}{The phylogeny of interest in phylo format}

\item{node}{The number of the node that you want the ancestor for}
}
\value{
A two-element vector, where the first element is the node of the ancestor and the second element is the number of the edge that connects the node and ancestor (i.e., the row number in phyl$edge).
}
\description{
This function will find the ancestor of a given node in a phylogeny.  It will return a two-element vector, which will contain both the node of the ancestor and the number of the edge that connects the node and ancestor.
}
\details{
Returns a two-element vector.  The node of the ancestor is first;  the edge that connects that node with its ancestor is second.
}
\examples{
phyl<-rtree(10)
ancestor<-findanc(phyl,1)
}
\references{
Paradis, E., J. Claude, and K. Strimmer (2004) APE: Analyses of phylogenetics
and evolution in R langauge. Bioinformatics, 20, 289-290.
Paradis, E. (2012) Analysis of Phylogenetics and Evolution with R (Second Edition). New York: Springer.
}

