% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/distributions.R
\name{DISCRETE}
\alias{DISCRETE}
\alias{new_DISCRETE}
\title{Factory for a DISCRETE distribution object}
\usage{
new_DISCRETE(p_supp, p_prob, p_dimnames = "rvar")
}
\arguments{
\item{p_supp}{A numeric vector of options}

\item{p_prob}{A numeric vector of probabilities.}

\item{p_dimnames}{A character that represents the name of the dimension}
}
\value{
An object of class \code{DISTRIBUTION}, \code{DISCRETE}
}
\description{
Returns an DISCRETE distribution object that sample from the vector \code{p_supp} of
options with probability the vector of probabilities \code{p_prob}.
}
\note{
If the second argument is missing, all options will be sample with
 equal probability. If provided, the second argument would add to 1 and must
 be the same length that the first argument
}
\examples{
myDistr <- new_DISCRETE(p_supp=c(1,2,3,4), p_prob=c(0.40,0.30,0.20,0.10))
myDistr$rfunc(10)
}
\author{
John J. Aponte
}
