% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/SpotIV.R
\name{SpotIV}
\alias{SpotIV}
\title{SpotIV method for causal inference in semi-parametric outcome model}
\usage{
SpotIV(
  Y,
  D,
  Z,
  X = NULL,
  intercept = TRUE,
  invalid = TRUE,
  d1,
  d2,
  w0,
  M.est = TRUE,
  M = 2,
  bs.Niter = 40,
  bw = NULL
)
}
\arguments{
\item{Y}{The outcome observation, a vector of length \eqn{n}.}

\item{D}{The treatment observation, a vector of length \eqn{n}.}

\item{Z}{The instrument observation of dimension \eqn{n \times p_z}.}

\item{X}{The covariates observation of dimension \eqn{n \times p_x}.}

\item{intercept}{Whether the intercept is included. (default = \code{TRUE})}

\item{invalid}{If TRUE, the method is robust to the presence of possibly invalid IVs; If FALSE, the method assumes all IVs to be valid. (default = \code{TRUE})}

\item{d1}{A treatment value for computing CATE(d1,d2|w0).}

\item{d2}{A treatment value for computing CATE(d1,d2|w0).}

\item{w0}{A vector of the instruments and baseline covariates for computing CATE(d1,d2|w0).}

\item{M.est}{If \code{TRUE}, \code{M} is estimated based on BIC, otherwise \code{M} is specified by input value of \code{M}. (default = \code{TRUE})}

\item{M}{The dimension of indices in the outcome model, from 1 to 3. (default = \code{2})}

\item{bs.Niter}{The bootstrap resampling size for constructing the confidence interval.}

\item{bw}{A (M+1) by 1 vector bandwidth specification. (default = \code{NULL})}
}
\value{
\code{SpotIV} returns an object of class "SpotIV", which "SpotIV" is a list containing the following components:
    \item{\code{betaHat}}{The estimate of the model parameter in front of the treatment.}
    \item{\code{cateHat}}{The estimate of CATE(d1,d2|w0).}
    \item{\code{cate.sdHat}}{The estimated standard error of cateHat.}
    \item{\code{SHat}}{The set of relevant IVs.}
    \item{\code{VHat}}{The set of relevant and valid IVs.}
    \item{\code{Maj.pass}}{The indicator that the majority rule is satisfied.}
}
\description{
Perform causal inference in the semi-parametric outcome model with possibly invalid IVs.
}
\examples{
\donttest{
data("nonlineardata")
Y <- nonlineardata[,"CVD"]
D <- nonlineardata[,"bmi"]
Z <- as.matrix(nonlineardata[,c("Z.1","Z.2","Z.3","Z.4")])
X <- as.matrix(nonlineardata[,c("age","sex")])
d1 <- median(D)+1
d2 <- median(D)
w0 <- c(rep(0,4), 30, 1)
SpotIV.model <- SpotIV(Y,D,Z,X,invalid = TRUE,d1 =d1, d2 = d2,w0 = w0)
summary(SpotIV.model)
}

}
\references{
{
Li, S., Guo, Z. (2020), Causal Inference for Nonlinear Outcome Models with Possibly Invalid Instrumental Variables, Preprint \emph{arXiv:2010.09922}.\cr
}
}
