% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/use_contrast.R
\name{use_contrasts.matrix}
\alias{use_contrasts.matrix}
\title{Matrix method for use_contrasts}
\usage{
\method{use_contrasts}{matrix}(
  factor_col,
  code_by = NA,
  reference_level = NA,
  set_intercept = NA,
  drop_trends = NA,
  labels = NULL,
  as_is = FALSE,
  ...
)
}
\arguments{
\item{factor_col}{A factor vector, eg from df$factorVarName}

\item{code_by}{A matrix to be used as the contrast matrix, should have
the same dimensions as the contrast matrix already applied to code_by}

\item{reference_level}{Not used}

\item{set_intercept}{Not used}

\item{drop_trends}{Not used}

\item{labels}{A vector of labels to apply to the matrix column names, default}

\item{as_is}{Logical, default FALSE, whether to leave the resulting matrix}

\item{...}{Additional arguments, not used}
}
\value{
A contrast coding matrix with labels and proper reference level
}
\description{
If a user provides a raw matrix, then use that matrix as the contrast matrix
}
\examples{

contrast_matrix <- sum_code(4)
use_contrasts(gl(4,1), contrast_matrix)

}
