% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/enlist_contrasts.R
\name{.split_if_language}
\alias{.split_if_language}
\title{Split contrast function using parens}
\usage{
.split_if_language(params, var_envir)
}
\arguments{
\item{params}{Parameters extracted from formula parsing}

\item{var_envir}{Environment to evaluate expressions in}
}
\value{
Parameter list with \code{code_by} set to the correct symbol & an
additional list entry for other arguments, which will be empty if no
arguments are provided.
}
\description{
If something like \code{set_contrasts(df, var ~ sum_code())} then what's
extracted from the formula isn't the symbol for the function \code{sum_code} but
a language object. This can be converted to a list to extract the function
symbol and then any arguments provided in the parens. The latter needs to
be evaluated in the original environment, for example if
\verb{set_contrasts(df, var ~ sum_code(scores=c(.1,.5,.6))} is called, the scores
list would not evaluate the \code{c(...)} call, yielding an error that the scores
argument isn't the right length (because it would be length 1, not 3).
}
\keyword{internal}
