% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/Pearson_LR_tests_unspecific_ordering_rx2.R
\name{Pearson_LR_tests_unspecific_ordering_rx2}
\alias{Pearson_LR_tests_unspecific_ordering_rx2}
\title{The Pearson chi-squared and likelihood ratio tests for unspecific ordering in rx2 tables}
\usage{
Pearson_LR_tests_unspecific_ordering_rx2(n, direction)
}
\arguments{
\item{n}{the observed counts (an rx2 matrix)}

\item{direction}{the direction of the success probabilities ("increasing" or "decreasing")}
}
\value{
An object of the \link{contingencytables_result} class,
basically a subclass of \code{\link[base:list]{base::list()}}. Use the \code{\link[utils:str]{utils::str()}} function
to see the specific elements returned.
}
\description{
The Pearson chi-squared and likelihood ratio tests for unspecific ordering in rx2 tables.
Described in Chapter 5 "The Ordered rx2 Table".
May also be used for 2xc tables, after flipping rows and columns (i.e. if
n is a 2xc table, call this function with n' (the transpose of n) as the
first argument).
}
\examples{
# Chapter 5: Alcohol consumption and malformations (Mills and Graubard, 1987)
Pearson_LR_tests_unspecific_ordering_rx2(mills_graubard_1987, "increasing")

# Chapter 5: Elevated troponin T levels in stroke patients (Indredavik et al., 2008)
Pearson_LR_tests_unspecific_ordering_rx2(indredavik_2008, "decreasing")

# Chapter 6: Postoperative nausea (Lydersen et al., 2012a)
Pearson_LR_tests_unspecific_ordering_rx2(t(lydersen_2012a), "decreasing")
}
