% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/contact_countries.R
\name{contact_df_countries}
\alias{contact_df_countries}
\title{Get a data.frame (in long format) of contact data for multiple countries}
\usage{
contact_df_countries(
  countries,
  location = c("all", "home", "school", "work", "other")
)
}
\arguments{
\item{countries}{A character string or a vector of character containing the
names of the countries for which to return contact data}

\item{location}{Character. One of "all", "home", "school", "work" or "other".}
}
\value{
A data.frame (in long format) with 4 columns:
\itemize{
\item \code{country}: the country name
\item \code{age_from}: the age group of individual
\item \code{age_to}: the age group of contact
\item \code{contact}: the intensity of contact
}
}
\description{
Get a data.frame (in long format) of contact data for multiple countries
}
\examples{
contact_df_countries(c("Austria", "Belgium"), location = "all")

}
\references{
Kiesha Prem, Alex R. Cook, Mark Jit, Projecting social contact
matrices in 152 countries using contact surveys and demographic data, PLoS
Comp. Biol. (2017), \doi{10.1371/journal.pcbi.1005697}
}
