% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/s3-object.R
\name{opts_object}
\alias{opts_object}
\title{Constructive options for class 'object'}
\usage{
opts_object(constructor = c("prototype", "S7_object"), ...)
}
\arguments{
\item{constructor}{String. Name of the function used to construct the object.}

\item{...}{Additional options used by user defined constructors through the \code{opts} object}
}
\value{
An object of class <constructive_options/constructive_options_object>
}
\description{
These options will be used on objects of class 'object'. The 'object' type
is particular in that it is an internal type in base R, but can only be
produced at time of writing through the 'S7' package. Well this is not
completely true since those can be built from S4 objects that we remove
the S4 flag from by using \code{asS3(x, complete = FALSE)} but we don't propose
this for now.
}
\details{
Depending on \code{constructor}, we construct the object as follows:
\itemize{
\item \code{"S7_object"} (default): We build the object using \code{S7::S7_object()}.
At the time of writing, this is currently the only way to create these objects.
\item \code{"next"} : Use the constructor for the next supported class.
}
}
