% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/s3-POSIXct.R
\name{opts_POSIXct}
\alias{opts_POSIXct}
\title{Constructive options for class 'POSIXct'}
\usage{
opts_POSIXct(
  constructor = c("as.POSIXct", ".POSIXct", "as_datetime", "as.POSIXct.numeric",
    "as_datetime.numeric", "next", "atomic"),
  ...,
  origin = "1970-01-01"
)
}
\arguments{
\item{constructor}{String. Name of the function used to construct the object, see Details section.}

\item{...}{Additional options used by user defined constructors through the \code{opts} object}

\item{origin}{Origin to be used, ignored when irrelevant.}
}
\value{
An object of class <constructive_options/constructive_options_POSIXct>
}
\description{
These options will be used on objects of class 'POSIXct'.
}
\details{
Depending on \code{constructor}, we construct the object as follows:
\itemize{
\item \code{"as.POSIXct"} (default): Build the object using a \code{as.POSIXct()} call on a
character vector.
\item \code{".POSIXct"} : Build the object using a \code{.POSIXct()} call on a numeric vector.
\item \code{"as_datetime"} : Build the object using a \code{lubridate::as_datetime()} call on
a character vector.
\item \code{"next"} : Use the constructor for the next supported class. Call \code{.class2()}
on the object to see in which order the methods will be tried.
\item \code{"atomic"} : We define as an atomic vector and repair attributes.
}

If the data is not appropriate for a constructor we fall back to another one
appropriately. In particular corrupted POSIXct objects such as those defined
on top of integers (or worse) are all constructed with the \code{".POSIXct"} constructor.
}
