% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/s3-data.frame.R
\name{opts_data.frame}
\alias{opts_data.frame}
\title{Constructive options for class 'data.frame'}
\usage{
opts_data.frame(
  constructor = c("data.frame", "read.table", "next", "list"),
  ...
)
}
\arguments{
\item{constructor}{String. Name of the function used to construct the environment, see Details section.}

\item{...}{Should not be used. Forces passing arguments by name.}
}
\value{
An object of class <constructive_options/constructive_options_data.frame>
}
\description{
These options will be used on objects of class 'data.frame'.
}
\details{
Depending on \code{constructor}, we construct the object as follows:
\itemize{
\item \code{"data.frame"} (default): Wrap the column definitions in a \code{data.frame()} call. If some
columns are lists or data frames, we wrap the column definitions in \code{tibble::tibble()}.
then use \code{as.data.frame()}.
\item \code{"read.table"} : We build the object using \code{read.table()} if possible, or fall
back to \code{data.frame()}.
\item \code{"next"} : Use the constructor for the next supported class. Call \code{.class2()}
on the object to see in which order the methods will be tried.
\item \code{"list"} : Use \code{list()} and treat the class as a regular attribute.
}
}
