% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/construct_idiomatic.R
\name{.cstr_apply}
\alias{.cstr_apply}
\title{.cstr_apply}
\usage{
.cstr_apply(
  args,
  fun = "list",
  ...,
  trailing_comma = FALSE,
  recurse = TRUE,
  implicit_names = FALSE,
  new_line = TRUE,
  one_liner = FALSE
)
}
\arguments{
\item{args}{A list of arguments to construct recursively, or code if \code{recurse = FALSE}.
If elements are named, the arguments will be named in the generated code.}

\item{fun}{The function name to use to build code of the form "fun(...)"}

\item{...}{options passed recursively to the further methods}

\item{trailing_comma}{leave a trailing comma after the last argument if
the code is multiline, some constructors allow it (e.g. \code{tibble::tibble()}) and it makes for nicer
diffs in version control.}

\item{recurse}{Whether to recursively generate the code to construct \code{args}. If \code{FALSE} arguments
are expected to contain code.}

\item{implicit_names}{When data is provided, compress calls of the form \code{f(a = a)} to \code{f(a)}}

\item{new_line}{passed to wrap to remove add a line after "fun(" and before ")", forced to
\code{FALSE} if \code{one_liner} is \code{TRUE}}

\item{one_liner}{Whether to return a one line call.}
}
\value{
A character vector of code
}
\description{
Exported for custom constructor design. If \code{recurse} is \code{TRUE} (default), we
recurse to construct \code{args} and insert their construction code in a \code{fun(...)} call returned
as a character vector. If \code{args} already contains code rather than object to
construct one should set \code{recurse} to \code{FALSE}.
}
\examples{
a <- 1
.cstr_apply(list(a=a), "foo")
.cstr_apply(list(a=a), "foo", data = list(a=1))
.cstr_apply(list(a=a), "foo", data = list(a=1), implicit_names = TRUE)
.cstr_apply(list(b=a), "foo", data = list(a=1), implicit_names = TRUE)
.cstr_apply(list(a="c(1,2)"), "foo")
.cstr_apply(list(a="c(1,2)"), "foo", recurse = FALSE)
}
