% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/console_file_menu.R
\name{console_file_menu}
\alias{console_file_menu}
\title{Prints out a menu from a list of file names in a folder for user selection}
\usage{
console_file_menu(
  folder_path = ".",
  pattern = NULL,
  instruction_msg = "Type the number in the console your choice and press enter: ",
  quit_key = "q",
  quit_message = paste0("To quit please type ", quit_key, " and press return."),
  return_number = FALSE,
  test_args = list(test_mode = FALSE, test_input = NA_character_)
)
}
\arguments{
\item{folder_path}{character.}

\item{pattern}{character. Regex pattern used in list.files.}

\item{instruction_msg}{character.  Message shows under the menu selection.}

\item{quit_key}{character.  Character value for the user to quit the menu.}

\item{quit_message}{character.  Character value to explain how to quit the menu.}

\item{return_number}{logical.  TRUE return number choice.  FALSE returns the index of chr_vector.}

\item{test_args}{list(test_mode logical, test_input character).  Only use for testing.}
}
\value{
character
}
\description{
wrapper function to console_menu.
}
\examples{
\dontrun{
console_file_menu("/folder/path/with/files")

console_file_menu("/folder/path/with/files",
                  ".bmp",
                  instruction_msg = "Please select a file to open")

console_file_menu(folder_path = "/folder/path/with/files",
                 pattern = "example_doc",
                 instruction_msg = "Choose a excel file to open",
                 quit_key = "Q",
                 quit_message = "Type in Q and press return to quit",
                 return_number = TRUE)

# Example code on how the function could be used
user_choice <- console_file_menu("/folder/path/", ".doc")

switch_result <- switch(
    user_choice,
    "document_one.doc" = # code here,
    "document_two.doc" = # code here,
    "q" = # exit code here
)
# Example code if the function returned the number in the list
user_choice <- console_file_menu("/folder/path/", ".doc", return_number = FALSE)

switch_result <- switch(
    user_choice,
    "1" = # code here,
    "2" = # code here,
    "q" = # exit code here
)
}
}
