% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/conos.R
\name{scanKModularity}
\alias{scanKModularity}
\title{Scan joint graph modularity for a range of k (or k.self) values
Builds graph with different values of k (or k.self if scan.k.self=TRUE), evaluating modularity of the resulting multilevel clustering
NOTE: will run evaluations in parallel using con$n.cores (temporarily setting con$n.cores to 1 in the process)}
\usage{
scanKModularity(
  con,
  min = 3,
  max = 50,
  by = 1,
  scan.k.self = FALSE,
  omit.internal.edges = TRUE,
  verbose = TRUE,
  plot = TRUE,
  ...
)
}
\arguments{
\item{con}{Conos object to test}

\item{min}{numeric Minimal value of k to test (default=3)}

\item{max}{numeric Value of k to test (default=50)}

\item{by}{numeric Scan step (default=1)}

\item{scan.k.self}{boolean Whether to test dependency on scan.k.self (default=FALSE)}

\item{omit.internal.edges}{boolean Whether to omit internal edges of the graph (default=TRUE)}

\item{verbose}{boolean Whether to provide verbose output (default=TRUE)}

\item{plot}{boolean Whether to plot the output (default=TRUE)}

\item{...}{other parameters will be passed to con$buildGraph()}
}
\value{
a data frame with $k $m columns giving k and the corresponding modularity
}
\description{
Scan joint graph modularity for a range of k (or k.self) values
Builds graph with different values of k (or k.self if scan.k.self=TRUE), evaluating modularity of the resulting multilevel clustering
NOTE: will run evaluations in parallel using con$n.cores (temporarily setting con$n.cores to 1 in the process)
}
