% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/cnt_generics.R, R/fs_methods.R
\name{upload_cnt}
\alias{upload_cnt}
\alias{upload_cnt.ConnectorFS}
\title{Upload content to the connector}
\usage{
upload_cnt(
  connector_object,
  file,
  name = basename(file),
  overwrite = zephyr::get_option("overwrite", "connector"),
  ...
)

\method{upload_cnt}{ConnectorFS}(
  connector_object,
  file,
  name = basename(file),
  overwrite = zephyr::get_option("overwrite", "connector"),
  ...
)
}
\arguments{
\item{connector_object}{\link{Connector} The connector object to use.}

\item{file}{\link{character} Path to the file to download to or upload from}

\item{name}{\link{character} Name of the content to read, write, or remove. Typically the table name.}

\item{overwrite}{Overwrite existing content if it exists in the connector?. Default: \code{FALSE}.}

\item{...}{Additional arguments passed to the method for the individual connector.}
}
\value{
\link{invisible} connector_object.
}
\description{
Generic implementing of how to upload files to a connector:

\itemize{
\item \link{ConnectorFS}: Uses \code{\link[fs:copy]{fs::file_copy()}} to copy the \code{file} to the file storage.
}
}
\examples{
# Upload file to a file storage

writeLines("this is an example", "example.txt")

folder <- withr::local_tempdir()
cnt <- connector_fs(folder)

cnt |>
  list_content_cnt(pattern = "example.txt")

cnt |>
  upload_cnt("example.txt")

cnt |>
  list_content_cnt(pattern = "example.txt")

cnt |>
  remove_cnt("example.txt")

file.remove("example.txt")

}
