% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/ci_quantile_diff.R
\name{ci_quantile_diff}
\alias{ci_quantile_diff}
\title{Confidence Interval for the Population Quantile Difference of two Samples}
\usage{
ci_quantile_diff(
  x,
  y,
  q = 0.5,
  probs = c(0.025, 0.975),
  type = "bootstrap",
  boot_type = c("bca", "perc", "norm", "basic"),
  R = 9999,
  seed = NULL,
  ...
)
}
\arguments{
\item{x}{A numeric vector.}

\item{y}{A numeric vector.}

\item{q}{A single probability value determining the quantile. Set to 0.5 for the median (default).}

\item{probs}{Error probabilites. The default c(0.025, 0.975) gives a symmetric 95\% confidence interval.}

\item{type}{Type of confidence interval. Currently, "bootstrap" is the only option.}

\item{boot_type}{Type of bootstrap confidence interval ("bca", "perc", "norm", "basic").}

\item{R}{The number of bootstrap resamples.}

\item{seed}{An integer random seed.}

\item{...}{Further arguments passed to \code{boot::boot}.}
}
\value{
A list with class \code{cint} containing these components:
\itemize{
\item \code{parameter}: The parameter in question.
\item \code{interval}: The confidence interval for the parameter.
\item \code{estimate}: The estimate for the parameter.
\item \code{probs}: A vector of error probabilities.
\item \code{type}: The type of the interval.
\item \code{info}: An additional description text for the interval.
}
}
\description{
This function calculates bootstrap confidence intervals for the population value of q quantile(x) - q quantile(y).
}
\details{
Bootstrap confidence intervals are calculated by the package "boot". The default bootstrap type is "bca" (bias-corrected & accelerated) as it enjoys the property of being second order accurate and is transformation respecting (see Efron, p. 188).
The sampling is done within sample.
}
\examples{
x <- 10:30
y <- 1:30
ci_quantile_diff(x, y, R = 999)
}
\references{
\enumerate{
\item Efron, B. and Tibshirani R. J. (1994). An Introduction to the Bootstrap. Chapman & Hall/CRC.
\item Canty, A and Ripley B. (2019). boot: Bootstrap R (S-Plus) Functions.
}
}
\seealso{
\code{\link{ci_median_diff}}.
}
