% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/utility.R
\encoding{UTF-8}
\name{vech2full}
\alias{vech2full}
\alias{vechs2full}
\title{Inverse vectorize a matrix}
\usage{
vech2full(x)

vechs2full(x, diagonal = 1)
}
\arguments{
\item{x}{A vector}

\item{diagonal}{A value or vector of values to enter on the diagonal for \code{vechs2full} (default = 1)}
}
\value{
A symmetric matrix
}
\description{
These functions return the symmetric matrix that produces the given
half-vectorization result.
}
\details{
The input consists of a vector ofthe elements in the lower triangle
of the resulting matrix (for \code{vech2full}, including the elements along the diagonal
of the matrix, as a column vector), filled column-wise. For \code{vechs2full},
the diagonal values are filled as 1 by defualt, alternative values can be
specified using the \code{diag} argument. The inverse half-vectorization takes a
vector and reconstructs a symmetric matrix such that vech2full(vech(x)) is
identical to x if x is symmetric.
}
\examples{
vech2full(c(1, 2, 3, 5, 6, 9))
vechs2full(c(2, 3, 6), diagonal = 0)
}
\author{
Based on functions from the the \pkg{OpenMx} package
}
