% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/convert.R
\name{convert.config}
\alias{convert.config}
\title{Covert configuration file from JSON/INI/YAML/TOML to JSON/INI/YAML}
\usage{
convert.config(file = Sys.getenv("R_CONFIGFILE_ACTIVE", "config.cfg"),
  out.file = Sys.getenv("R_CONFIGFILE_ACTIVE", "config.cfg"),
  convert.to = "ini", ...)
}
\arguments{
\item{file}{File name of configuration file to read from. Defaults to the value of
the 'R_CONFIGFILE_ACTIVE' environment variable ('config.cfg' if the
variable does not exist and JSON/INI/YAML/TOML format only)}

\item{out.file}{Output path of configuration file. Defaults to the value of
the 'R_CONFIGFILE_ACTIVE' environment variable ('config.cfg' if the
variable does not exist)}

\item{convert.to}{JSON/INI/YAML}

\item{...}{Arguments for \code{\link{read.config}} and \code{\link{write.config}}}
}
\value{
Logical indicating whether convert success
}
\description{
Covert configuration file from JSON/INI/YAML/TOML to JSON/INI/YAML
}
\examples{
config.json <- system.file('extdata', 'config.json', package='configr')
config <- convert.config(file=config.json, out.file = sprintf('\%s/config.ini', tempdir()))
}
\seealso{
\code{\link[jsonlite]{fromJSON}} JSON file will read by this

\code{\link[ini]{read.ini}} INI file will read by this

\code{\link[yaml]{yaml.load_file}} YAML file will read by this
}
