% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/concstats.R
\name{concstats}
\alias{concstats}
\title{A set of Market Structure, Concentration, and Inequality Measures}
\usage{
concstats(x, na.rm = TRUE)
}
\arguments{
\item{x}{a non-negative numeric vector.}

\item{na.rm}{a logical vector that indicates whether \code{NA} values should
be excluded or not.
If set to \code{FALSE} the computation yields \code{NA}.}
}
\value{
returns a data frame of calculated measures
.
}
\description{
a convenience function which calculates a selected set of
different market structure, inequality and concentration measures more or
less commonly used, e.g. k-firm ratios, Entropy, HHI, Palma ratio,
and others in a one step procedure to provide a first overview.
}
\details{
\code{concstats} computes a set of different and selected
structural, inequality, and concentration measures in a one step procedure,
however, all measures can be computed individually or in groups.
}
\note{
the vector of market shares should be in a decimal form corresponding
to the total share of individual firms/units. The vector should sum up to 1.
}
\examples{
# a vector of market shares
# share <- c(0.35, 0.4, 0.05, 0.1, 0.06, 0.04)
# a selected set of different structural, concentration, and inequality
# measures
# share_conc <- concstats(share)

}
\seealso{
{\code{\link{mstruct}}, \code{\link{comp}}, \code{\link{inequ}}}
}
