
<!-- README.md is generated from README.Rmd. Please edit that file -->
comtradr
========

[![Travis-CI Build Status](https://travis-ci.org/ChrisMuir/comtradr.svg?branch=master)](https://travis-ci.org/ChrisMuir/comtradr)

R package for interacting with the [UN Comtrade Database](https://comtrade.un.org/data/) public API. UN Comtrade provides historical data on the weights and value of specific goods shipped between countries, more info can be found [here](https://comtrade.un.org/). Full API documentation can be found [here](https://comtrade.un.org/data/doc/api/).

This package was inspired by the [R tutorial](https://comtrade.un.org/data/Doc/api/ex/r) posted by Comtrade, and is built using [httr](https://CRAN.R-project.org/package=httr) and [jsonlite](https://CRAN.R-project.org/package=jsonlite).

Please [report](https://github.com/ChrisMuir/comtradr/issues) issues, comments, or features requests.

Installation
------------

``` r
# install.packages("devtools")
devtools::install_github("ChrisMuir/comtradr")
```

Example Usage
-------------

**Example 1**: Return all exports from China to South Korea, United States and Mexico, for all years

``` r
library(comtradr)

# First, read in the country code lookup table as a dataframe from Comtrade.
# This will be used as a parameter in the API calls.
countrydf <- ct_countries_table()

# This object can can also be used to look up the exact spellings of countries
# prior to making API calls.
country_lookup("korea", "reporter", countrydf)
#> [1] "Dem. People's Rep. of Korea" "Rep. of Korea"

# Since we want South Korea, we'll use "Rep. of Korea" within the API query.
example1 <- ct_search(reporters = "China",
                      partners = c("Rep. of Korea", "USA", "Mexico"),
                      countrytable = countrydf,
                      tradedirection = "exports")

# Inspect the return data
str(example1$data)
#> 'data.frame':    72 obs. of  35 variables:
#>  $ Classification        : chr  "H4" "H4" "H4" "H4" ...
#>  $ Year                  : int  2012 2012 2012 2013 2013 2013 2014 2014 2014 2015 ...
#>  $ Period                : int  2012 2012 2012 2013 2013 2013 2014 2014 2014 2015 ...
#>  $ Period Desc.          : chr  "2012" "2012" "2012" "2013" ...
#>  $ Aggregate Level       : int  0 0 0 0 0 0 0 0 0 0 ...
#>  $ Is Leaf Code          : int  0 0 0 0 0 0 0 0 0 0 ...
#>  $ Trade Flow Code       : int  2 2 2 2 2 2 2 2 2 2 ...
#>  $ Trade Flow            : chr  "Export" "Export" "Export" "Export" ...
#>  $ Reporter Code         : int  156 156 156 156 156 156 156 156 156 156 ...
#>  $ Reporter              : chr  "China" "China" "China" "China" ...
#>  $ Reporter ISO          : chr  "CHN" "CHN" "CHN" "CHN" ...
#>  $ Partner Code          : int  410 484 842 410 484 842 410 484 842 410 ...
#>  $ Partner               : chr  "Rep. of Korea" "Mexico" "USA" "Rep. of Korea" ...
#>  $ Partner ISO           : chr  "KOR" "MEX" "USA" "KOR" ...
#>  $ 2nd Partner Code      : logi  NA NA NA NA NA NA ...
#>  $ 2nd Partner           : chr  "" "" "" "" ...
#>  $ 2nd Partner ISO       : chr  "" "" "" "" ...
#>  $ Customs Proc. Code    : chr  "" "" "" "" ...
#>  $ Customs               : chr  "" "" "" "" ...
#>  $ Mode of Transport Code: chr  "" "" "" "" ...
#>  $ Mode of Transport     : chr  "" "" "" "" ...
#>  $ Commodity Code        : chr  "TOTAL" "TOTAL" "TOTAL" "TOTAL" ...
#>  $ Commodity             : chr  "All Commodities" "All Commodities" "All Commodities" "All Commodities" ...
#>  $ Qty Unit Code         : int  1 1 1 1 1 1 1 1 1 1 ...
#>  $ Qty Unit              : chr  "No Quantity" "No Quantity" "No Quantity" "No Quantity" ...
#>  $ Qty                   : logi  NA NA NA NA NA NA ...
#>  $ Alt Qty Unit Code     : chr  "" "" "" "" ...
#>  $ Alt Qty Unit          : logi  NA NA NA NA NA NA ...
#>  $ Alt Qty               : logi  NA NA NA NA NA NA ...
#>  $ Netweight (kg)        : logi  NA NA NA NA NA NA ...
#>  $ Gross weight (kg)     : logi  NA NA NA NA NA NA ...
#>  $ Trade Value (US$)     : num  8.77e+10 2.75e+10 3.52e+11 9.12e+10 2.90e+10 ...
#>  $ CIF Trade Value (US$) : logi  NA NA NA NA NA NA ...
#>  $ FOB Trade Value (US$) : logi  NA NA NA NA NA NA ...
#>  $ Flag                  : int  0 0 0 0 0 0 0 0 0 0 ...
```

**Example 2**: Return all exports related to shrimp from Thailand to all other countries, for years 2007 thru 2011

``` r
library(comtradr)

# First, read in the commodity code lookup table as a dataframe from Comtrade.
commoditydf <- ct_commodities_table("HS")

# Then search for shrimp.
commodity_lookup("shrimp", commoditydf)
#> [1] "030613 - Shrimps and prawns, frozen"                                                                                                                                                                                                         
#> [2] "030623 - Shrimps and prawns, not frozen"                                                                                                                                                                                                     
#> [3] "160520 - Shrimps and prawns, prepared or preserved"                                                                                                                                                                                          
#> [4] "160521 - Preparations of meat, of fish or of crustaceans, molluscs or other aquatic invertebrates // Crustaceans, molluscs and other aquatic invertebrates, prepared or preserved. // - Shrimps and prawns : // -- Not in airtight container"
#> [5] "160529 - Preparations of meat, of fish or of crustaceans, molluscs or other aquatic invertebrates // Crustaceans, molluscs and other aquatic invertebrates, prepared or preserved. // - Shrimps and prawns : // -- Other"

# API query.
example2 <- ct_search(reporters = "Thailand",
                      partners = "All",
                      countrytable = countrydf,
                      tradedirection = "exports",
                      startdate = "2007-01-01",
                      enddate = "2011-01-01",
                      commodcodes = c("030613",
                                      "030623",
                                      "160520",
                                      "160521",
                                      "160529"))

# Inspect the output
str(example2$data)
#> 'data.frame':    1056 obs. of  35 variables:
#>  $ Classification        : chr  "H3" "H3" "H3" "H3" ...
#>  $ Year                  : int  2007 2007 2007 2007 2007 2007 2007 2007 2007 2007 ...
#>  $ Period                : int  2007 2007 2007 2007 2007 2007 2007 2007 2007 2007 ...
#>  $ Period Desc.          : chr  "2007" "2007" "2007" "2007" ...
#>  $ Aggregate Level       : int  6 6 6 6 6 6 6 6 6 6 ...
#>  $ Is Leaf Code          : int  1 1 1 1 1 1 1 1 1 1 ...
#>  $ Trade Flow Code       : int  2 2 2 2 2 2 2 2 2 2 ...
#>  $ Trade Flow            : chr  "Export" "Export" "Export" "Export" ...
#>  $ Reporter Code         : int  764 764 764 764 764 764 764 764 764 764 ...
#>  $ Reporter              : chr  "Thailand" "Thailand" "Thailand" "Thailand" ...
#>  $ Reporter ISO          : chr  "THA" "THA" "THA" "THA" ...
#>  $ Partner Code          : int  0 36 40 48 56 104 116 124 152 156 ...
#>  $ Partner               : chr  "World" "Australia" "Austria" "Bahrain" ...
#>  $ Partner ISO           : chr  "WLD" "AUS" "AUT" "BHR" ...
#>  $ 2nd Partner Code      : logi  NA NA NA NA NA NA ...
#>  $ 2nd Partner           : chr  "" "" "" "" ...
#>  $ 2nd Partner ISO       : chr  "" "" "" "" ...
#>  $ Customs Proc. Code    : chr  "" "" "" "" ...
#>  $ Customs               : chr  "" "" "" "" ...
#>  $ Mode of Transport Code: chr  "" "" "" "" ...
#>  $ Mode of Transport     : chr  "" "" "" "" ...
#>  $ Commodity Code        : chr  "030613" "030613" "030613" "030613" ...
#>  $ Commodity             : chr  "Shrimps & prawns, whether/not in shell, frozen" "Shrimps & prawns, whether/not in shell, frozen" "Shrimps & prawns, whether/not in shell, frozen" "Shrimps & prawns, whether/not in shell, frozen" ...
#>  $ Qty Unit Code         : int  8 8 8 8 8 8 8 8 8 8 ...
#>  $ Qty Unit              : chr  "Weight in kilograms" "Weight in kilograms" "Weight in kilograms" "Weight in kilograms" ...
#>  $ Qty                   : logi  NA NA NA NA NA NA ...
#>  $ Alt Qty Unit Code     : chr  "" "" "" "" ...
#>  $ Alt Qty Unit          : int  169654441 5545602 1265 29780 2721318 750 8510 13088545 4930 3410678 ...
#>  $ Alt Qty               : logi  NA NA NA NA NA NA ...
#>  $ Netweight (kg)        : int  169654441 5545602 1265 29780 2721318 750 8510 13088545 4930 3410678 ...
#>  $ Gross weight (kg)     : logi  NA NA NA NA NA NA ...
#>  $ Trade Value (US$)     : int  1084677273 36120291 11888 124668 16061545 4521 74842 77292118 64218 18400152 ...
#>  $ CIF Trade Value (US$) : logi  NA NA NA NA NA NA ...
#>  $ FOB Trade Value (US$) : logi  NA NA NA NA NA NA ...
#>  $ Flag                  : int  0 0 0 0 0 0 0 0 0 0 ...
```
