% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/dates.R
\name{cs_parse_month}
\alias{cs_parse_month}
\title{Separate Coded Month}
\usage{
cs_parse_month(.data, var, yearVar, monthVar)
}
\arguments{
\item{.data}{A tibble or data frame}

\item{var}{the variable containing coded month and coded year}

\item{yearVar}{the name of the column to contain the year data}

\item{monthVar}{the name of the column to contain month data}
}
\value{
Returns a copy of the object with two new columns for the coded year
    and coded month appended to it.
}
\description{
Separates a column containing coded year and coded month
    separated by "-" into two columns and removes the input column.
}
\examples{
# load example data
testData <- january2018

# parse CodedMonth
testData <- cs_parse_month(testData, var = coded_month, yearVar = reportYear,
    monthVar = reportMonth)

}
