% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/cTransformations.R
\name{cscale}
\alias{cscale}
\alias{cdescale}
\title{Functions scale real and imaginary parts of a complex variable}
\usage{
cscale(y, scaling = c("normalisation", "standardisation", "max"))

cdescale(yScaled, y, scaling = c("normalisation", "standardisation", "max"))
}
\arguments{
\item{y}{vector of a complex variable in the original scale.}

\item{scaling}{scaling method to use. "normalisation" implies scaling
to make sure that \code{y} lie in [0, 1] (subtract the minimum value and divide by
the range). "standardisation" standardises the variable (i.e. subtract the mean
then divide by standard deviation). "max" just divides the variable by the
maximum value.}

\item{yScaled}{vector of the already scaled complex variable.}
}
\value{
A vector of the same size as \code{y}, containing scaled complex variable.
}
\description{
Function \code{cscale()} will do the scaling based on the selected method, while
the function \code{cdescale()} will transform the variable to get to the
original units.
}
\examples{

# Generate random complex variables
y <- complex(real=rnorm(100,10,10), imaginary=rnorm(100,10,10))

yScaled <- cscale(y)
cdescale(yScaled, y)

}
\references{
\itemize{
\item Svetunkov, S. & Svetunkov I. (2022) Complex Autoregressions. In Press.
}
}
\seealso{
\code{\link[base]{scale}}
}
\author{
Ivan Svetunkov, \email{ivan@svetunkov.ru}
}
\keyword{univar}
