% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/clm.R
\name{clm}
\alias{clm}
\alias{sigma.clm}
\alias{vcov.clm}
\alias{summary.clm}
\title{Complex Linear Model}
\usage{
clm(formula, data, subset, na.action, loss = c("likelihood", "OLS", "CLS",
  "MSE", "MAE", "HAM"), orders = c(0, 0, 0), scaling = c("normalisation",
  "standardisation", "max", "none"), parameters = NULL, fast = FALSE, ...)

\method{sigma}{clm}(object, type = NULL, ...)

\method{vcov}{clm}(object, type = NULL, ...)

\method{summary}{clm}(object, level = 0.95, ...)
}
\arguments{
\item{formula}{an object of class "formula" (or one that can be coerced to
that class): a symbolic description of the model to be fitted. Can also include
\code{trend}, which would add the global trend.}

\item{data}{a data frame or a matrix, containing the variables in the model.}

\item{subset}{an optional vector specifying a subset of observations to be
used in the fitting process.}

\item{na.action}{a function which indicates what should happen when the
data contain NAs. The default is set by the na.action setting of
\link[base]{options}, and is \link[stats]{na.fail} if that is unset. The
factory-fresh default is \link[stats]{na.omit}. Another possible value
is NULL, no action. Value \link[stats]{na.exclude} can be useful.}

\item{loss}{The type of Loss Function used in optimization. \code{loss} can
be:
\itemize{
\item \code{OLS} - Ordinary Least Squares method, relying on the minimisation of
the conjoint variance of the error term;
\item \code{CLS} - Complex Least Squares method, relying on the minimisation of
the complex variance of the error term;
\item \code{likelihood} - the model is estimated via the maximisation of the
likelihood of the complex Normal distribution;
\item \code{MSE} (Mean Squared Error),
\item \code{MAE} (Mean Absolute Error),
\item \code{HAM} (Half Absolute Moment),
}

A user can also provide their own function here as well, making sure
that it accepts parameters \code{actual}, \code{fitted} and \code{B}. Here is an
example:

\code{lossFunction <- function(actual, fitted, B, xreg) return(mean(abs(actual-fitted)))}
\code{loss=lossFunction}}

\item{orders}{vector of orders of complex ARIMA(p,d,q).}

\item{scaling}{NOT YET IMPLEMENTED!!! Defines what type of scaling to do for the variables.
See \link[complex]{cscale} for the explanation of the options.}

\item{parameters}{vector of parameters of the linear model. When \code{NULL}, it
is estimated.}

\item{fast}{if \code{TRUE}, then the function won't check whether
the data has variability and whether the regressors are correlated. Might
cause trouble, especially in cases of multicollinearity.}

\item{...}{Other parameters passed to internal functions.}

\item{object}{Object of class "clm" estimated via \code{clm()} function.}

\item{type}{Type of sigma to return. This is calculated based on the residuals
of the estimated model and can be \code{"direct"}, based on the direct variance,
\code{"conjugate"}, based on the conjugate variance and \code{"matrix"}, returning
covariance matrix for the complex error. If \code{NULL} then will return value based
on the loss used in the estimation: OLS -> "conjugate", CLS -> "direct", likelihood ->
"matrix".}

\item{level}{What confidence level to use for the parameters of the model.}
}
\value{
Function returns \code{model} - the final model of the class
"clm", which contains:
\itemize{
\item coefficients - estimated parameters of the model,
\item FI - Fisher Information of parameters of the model. Returned only when \code{FI=TRUE},
\item fitted - fitted values,
\item residuals - residuals of the model,
\item mu - the estimated location parameter of the distribution,
\item scale - the estimated scale parameter of the distribution. If a formula was provided for
scale, then an object of class "scale" will be returned.
\item logLik - log-likelihood of the model. Only returned, when \code{loss="likelihood"}
and in a special case of complex least squares.
\item loss - the type of the loss function used in the estimation,
\item lossFunction - the loss function, if the custom is provided by the user,
\item lossValue - the value of the loss function,
\item df.residual - number of degrees of freedom of the residuals of the model,
\item df - number of degrees of freedom of the model,
\item call - how the model was called,
\item rank - rank of the model,
\item data - data used for the model construction,
\item terms - terms of the data. Needed for some additional methods to work,
\item B - the value of the optimised parameters. Typically, this is a duplicate of coefficients,
\item other - the list of all the other parameters either passed to the
function or estimated in the process, but not included in the standard output
(e.g. \code{alpha} for Asymmetric Laplace),
\item timeElapsed - the time elapsed for the estimation of the model.
}
}
\description{
Function estimates complex variables model
}
\details{
This is a function, similar to \link[stats]{lm}, but supporting several estimation
techniques for complex variables regression.
}
\examples{

### An example with mtcars data and factors
x <- complex(real=rnorm(1000,10,10), imaginary=rnorm(1000,10,10))
a0 <- 10 + 15i
a1 <- 2-1.5i
y <- a0 + a1 * x + 1.5*complex(real=rnorm(length(x),0,1), imaginary=rnorm(length(x),0,1))

complexData <- cbind(y=y,x=x)
complexModel <- clm(y~x, complexData)
summary(complexModel)

plot(complexModel, 7)

}
\references{
\itemize{
\item Svetunkov, S. & Svetunkov I. (2022) Complex Autoregressions. In Press.
}
}
\seealso{
\code{\link[greybox]{alm}}
}
\author{
Ivan Svetunkov, \email{ivan@svetunkov.ru}
}
\keyword{models}
\keyword{nonlinear}
\keyword{regression}
\keyword{ts}
