% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/transactions.R
\docType{data}
\name{transactions_sample}
\alias{transactions_sample}
\title{Sampling of the full Complete Journey transactions.}
\format{A data frame with 100,000 rows and 11 variables
\describe{
  \item{household_id}{Uniquely identifies each household}
  \item{store_id}{Uniquely identifies each store}
  \item{basket_id}{Uniquely identifies a purchase occasion}
  \item{product_id}{Uniquely identifies each product}
  \item{quantity}{Number of the products purchased during the trip}
  \item{sales_value}{Amount of dollars retailer receives from sale}
  \item{retail_disc}{Discount applied due to retailer's loyalty card program}
  \item{coupon_disc}{Discount applied due to manufacturer coupon}
  \item{coupon_match_disc}{Discount applied due to retailer's match of manufacturer coupon}
  \item{week}{Week of the transaction; Ranges 1-53}
  \item{transaction_timestamp}{Date and time of when the transaction occurred}
}}
\source{
84.51°, Customer Journey study, \url{http://www.8451.com/area51/}
}
\description{
A sampling of all products purchased by households within the Complete Journey
study. Each line found in this table is essentially the same line that would
be found on a store receipt. This is only a subsample of the complete
data set to keep package size manageable.
}
\examples{
\donttest{
transactions_sample
}
}
\seealso{
Use \code{\link{get_transactions}} to download the entire transactions
  data containing all 1,469,307 rows.
}
