% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/head-to-head.R
\name{h2h_mat}
\alias{h2h_mat}
\alias{h2h_mat}
\alias{to_h2h_mat}
\title{Compute matrix format of Head-to-Head values}
\usage{
h2h_mat(cr_data, ..., fill = NULL)

to_h2h_mat(tbl, value = NULL, fill = NULL)
}
\arguments{
\item{cr_data}{Competition results ready for \code{\link[=as_longcr]{as_longcr()}}.}

\item{...}{Name-value pairs of Head-to-Head functions (see Details).}

\item{fill}{A single value to use instead of \code{NA} for missing pairs.}

\item{tbl}{Data frame in \link[=h2h_long]{long format} of Head-to-Head values.}

\item{value}{String name for column with Head-to-Head value.}
}
\value{
An object of class \code{h2h_mat} which is a \link{matrix} with row names
indicating first player in matchup, col names - second and values -
Head-to-Head values.
}
\description{
Functions to compute Head-to-Head values in matrix pair-value format.
}
\details{
\code{h2h_mat()} computes Head-to-Head values in
\link[=convert-pair-value]{matrix} format. It allows multiple Head-to-Head
functions in \code{...} but only first (if present) will be used. Basically, it
uses supplied function to compute long format of Head-to-Head values and then
\link[=long_to_mat]{transforms} it naturally to matrix, filling missing values
with \code{fill}.

\code{to_h2h_mat()} takes \strong{object of \link{h2h_long} structure} and converts it into
\code{h2h_mat} using column with name \code{value} for values and filling data for
implicitly missing (not explicitly provided in \code{tbl}) player pairs with
\code{fill}. If \code{value} is \code{NULL} it takes first non-player column. If there is no
such column, it will use vector of dummy values (\code{NA}s or \code{fill}s).
}
\section{Head-to-Head value}{

Head-to-Head value is a summary statistic of direct confrontation between two
players. It is assumed that this value can be computed based only on the
players' \link[=get_matchups]{matchups}. In other words, every game is converted
into series of "subgames" between ordered pairs of players (including
selfplay) which is stored as \link{widecr} object. After that, summary of item,
defined by columns \code{player1} and \code{player2}, is computed using
\code{\link[=summarise_item]{summarise_item()}}.

That said, name-value pairs of Head-to-Head functions should be defined as
for \code{summarise_item()} applied to data with columns \code{game}, \code{player1},
\code{score1}, \code{player2}, \code{score2}.
}

\examples{
# Only first function is used
ncaa2005 \%>\%
  h2h_mat(
    mean_score = mean(score1),
    mean_abs_score = mean(abs(score1 - score2))
  )

ncaa2005[-(1:2), ] \%>\%
  h2h_mat(mean_score = mean(score1), fill = 0)

}
\seealso{
\link[=h2h_long]{Long format} of Head-to-Head values.

\link[=h2h_funs]{Common Head-to-Head functions}.
}
