% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/supsc.R
\encoding{UTF-8}
\name{supsc}
\alias{supsc}
\title{Converts a string to UTF-8 superscript}
\usage{
supsc(x)
}
\arguments{
\item{x}{A string to be converted to superscript.}
}
\value{
The superscript version of the string passed to the function,
if one exists. Otherwise, a question mark will be returned.
}
\description{
The \code{supsc} function translates a normal character to a UTF-8
superscript character.  The function can be used to
generate superscripts for many common characters.  Most alphabetic
and numeric characters have UTF-8 superscripts.  This function is useful
because it saves you from having to look up the superscript character
code, or copy and pasting from the internet.  If a corresponding
superscript character code does not exist, a question mark
will be returned for that character.
}
\examples{
# Single letter
paste0(supsc("a"), "Footnote")

# Single number
paste0(supsc("1"), "Footnote")

# Character string
paste0("December 5", supsc("th"))

# Formula
paste0("x", supsc("(a+1)"))
}
\seealso{
The \code{\link{subsc}} function to get subscripts.
}
