% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/legend.R
\name{legend_timecycle}
\alias{legend_timecycle}
\title{Make an HCL legend for a cyclical sequence of distributions}
\usage{
legend_timecycle(
  palette,
  specificity = TRUE,
  origin_label = NULL,
  return_df = FALSE
)
}
\arguments{
\item{palette}{data frame containing a color palette generated by
\link{palette_timecycle}.}

\item{specificity}{logical indicating whether to visualize intensity
and layer information for three specificity values (i.e., 0, 50, 100) or
for a single specificity value (i.e., 100). Typically, a single specificity
value is appropriate for \link{map_multiples} visualizations.}

\item{origin_label}{character vector with a single element to be used as the
label at the 12 o'clock position of the legend wheel.}

\item{return_df}{logical indicating whether to return the legend as a
\code{ggplot2} object or return a data frame containing the necessary data to
build the legend.}
}
\value{
A \code{ggplot2} plot object of the legend. Alternatively,
\code{return_df = TRUE} will return a data frame containing the data needed
to build the legend. The data frame columns are:
\itemize{
\item \code{specificity}: the degree to which intensity values are unevenly
distributed across layers; mapped to chroma.
\item \code{layer_id}: integer identifying the layer containing the maximum
intensity value; mapped to hue.
\item \code{color}: the hexadecimal color associated with the given layer and
specificity values.
\item \code{intensity}: maximum cell value across layers divided by the maximum
value across all layers and cells; mapped to alpha level.
}
}
\description{
This function creates a legend to accompany a map describing
a cyclical sequence of distributions.
}
\examples{
# load field sparrow data
data(fiespa_occ)

# generate hcl palette
pal <- palette_timecycle(fiespa_occ)

# create legend for palette
legend_timecycle(pal)
}
\seealso{
\link{legend_timeline} for linear sequences of distributions and
\link{legend_set} for distributions of distinct groups.

Other legend: 
\code{\link{legend_set}()},
\code{\link{legend_timeline}()}
}
\concept{legend}
