% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/scale_colorhex.R
\name{scale-colorhex}
\alias{scale-colorhex}
\alias{scale_colour_colorhex_d}
\alias{scale_color_colorhex_d}
\alias{scale_fill_colorhex_d}
\alias{scale_colour_colorhex_c}
\alias{scale_color_colorhex_c}
\alias{scale_fill_colorhex_c}
\title{Colour scales for ggplot2}
\usage{
scale_colour_colorhex_d(x, type = "triadic", reverse = FALSE, ...)

scale_color_colorhex_d(x, type = "triadic", reverse = FALSE, ...)

scale_fill_colorhex_d(x, type = "triadic", reverse = FALSE, ...)

scale_colour_colorhex_c(x, type = "complementary", reverse = FALSE, ...)

scale_color_colorhex_c(x, type = "complementary", reverse = FALSE, ...)

scale_fill_colorhex_c(x, type = "complementary", reverse = FALSE, ...)
}
\arguments{
\item{x}{object of class \code{colorhex}}

\item{type}{character. Type of colours to use.
One of c("complementary", "triadic" (default), "shades", "tints", "related")}

\item{reverse}{logical. If scale should b reversed (default: FALSE)}

\item{...}{arguments to be passed to \code{\link[ggplot2]{discrete_scale}}}
}
\value{
a ggplot2-proto
}
\description{
Colour and fill scales for ggplot2
plots, using object of class \code{colorhex}
as basis for colour choices.
}
\details{
The \code{colorhex} class is a list where there
is a variety of extra information on the hex
colour selected. This information can be used
to create colour scales to be used in ggplot2.
}
\section{Functions}{
\itemize{
\item \code{scale_colour_colorhex_d}: Discrete colour scale

\item \code{scale_color_colorhex_d}: Discrete colour scale

\item \code{scale_fill_colorhex_d}: Discrete fill scale

\item \code{scale_colour_colorhex_c}: Continuous colour scale

\item \code{scale_color_colorhex_c}: Continuous colour scale

\item \code{scale_fill_colorhex_c}: Continuous fill scale
}}

\examples{
library(ggplot2)

x <- get_color("#008080")

ggplot(mtcars, aes(mpg)) +
   geom_density(aes(fill = disp, group = disp)) +
   scale_fill_colorhex_c(x)

ggplot(mtcars, aes(mpg)) +
  geom_density(aes(fill = disp, group = disp)) +
  scale_fill_colorhex_c(x, "tints")

ggplot(mtcars, aes(mpg)) +
  geom_density(aes(fill = disp, group = disp)) +
  scale_fill_colorhex_c(x, "shades")

ggplot(mtcars, aes(mpg, disp, colour = factor(cyl))) +
   geom_point() +
   scale_color_colorhex_d(x, "triadic")

ggplot(mtcars, aes(mpg, disp, colour = factor(cyl))) +
   geom_point() +
   scale_color_colorhex_d(x, "shades")
}
