% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/susie.R
\name{runsusie}
\alias{runsusie}
\title{Run susie on a single coloc-structured dataset}
\usage{
runsusie(
  d,
  suffix = 1,
  p = NULL,
  trimz = NULL,
  r2.prune = NULL,
  maxit = 100,
  repeat_until_convergence = TRUE,
  s_init = NULL,
  ...
)
}
\arguments{
\item{d}{coloc dataset, must include LD (signed correlation matrix)}

\item{suffix}{suffix label that will be printed with any error messages}

\item{p}{prior probability a snp is causal (equivalent to p1 or p2 in
coloc.abf). By default, this is set to NULL, upon which we will set a
small null_weight to pass to susie_rss() (see vignette a06 for details
why). You can override this by setting p as you would p1 or p2 in a coloc
function, but note that you may miss some true signals that way. Also note
that neither of these options correspond to the susie_rss() defaults,
because our goal here is not fine mapping alone.}

\item{trimz}{used to trim datasets for development purposes}

\item{r2.prune}{sometimes SuSiE can return multiple signals in high LD. if
you set r2.prune to a value between 0 and 1, sets with index SNPs with LD
greater than r2.prune}

\item{maxit}{maximum number of iterations for the first run of susie_rss().
If susie_rss() does not report convergence, runs will be extended assuming
repeat_until_convergence=TRUE. Most users will not need to change this
default.}

\item{repeat_until_convergence}{keep running until susie_rss() indicates
convergence. Default TRUE. If FALSE, susie_rss() will run with maxit
iterations, and if not converged, runsusie() will error. Most users will
not need to change this default.}

\item{s_init}{used internally to extend runs that haven't converged. don't
use.}

\item{...}{arguments passed to susie_rss. In particular, if you want to
match some coloc defaults, set
\itemize{
\item prior_variance=0.2^2 (if a case-control trait) or (0.15/sd(Y))^2 if a
quantitative trait
\item estimate_prior_variance=FALSE
}

otherwise susie_rss will estimate the prior variance itself}
}
\value{
results of a susie_rss run, with some added dimnames
}
\description{
run susie_rss storing some additional information for coloc
}
\examples{
library(coloc)
data(coloc_test_data)
result=runsusie(coloc_test_data$D1)
summary(result)
}
\author{
Chris Wallace
}
