% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/plotcollindlnm.R
\name{plot.collindlnmnonlinear}
\alias{plot.collindlnmnonlinear}
\title{Visualize effects of collinearity in distributed lag model under an
hypothetical non-linear effect pattern.}
\usage{
\method{plot}{collindlnmnonlinear}(
  x,
  lags = NULL,
  show = c("manual", "auto", "sequence"),
  addlegend = TRUE,
  varlegend = NULL,
  ...
)
}
\arguments{
\item{x}{an object of class \code{"collindlnmnonlinear"}, which is generated
by the function \code{\link{collindlnm}} with \code{shape = "nonlinear"}.}

\item{lags}{a number or a numeric vector indicating at what lags the results
will be visualized. Default (\code{NULL}) shows all lags.}

\item{show}{character indicating how the multiple plots will be shown. If
\code{show = "manual"}, then it is expected that the user have previously
set the graphical parameters to arrange them (i.e. setting \code{mfrow})
with \code{\link{par}}. If \code{show = "auto"}, then the arrangement of
the plots (i.e. the value of \code{mfrow}) is automatically set. If
\code{show = "sequence"}, then the plots are sequentially overlaid.}

\item{addlegend}{logical indicating whether a legend indicating at what
value (of \code{at} passed in \code{\link{collindlnm}}) the results
correspond to.}

\item{varlegend}{character indicating the label for the explored variable to
be shown in the legend.}

\item{...}{other parameters to be passed through to plot function.}
}
\value{
A plot showing a comparison between results under the fitted model
and the results under the hypothetical true effect, for each of the
different values of the variable of interest where effects were explored.
}
\description{
Visualize the results from a distributed lag model under an hypothetical
non-linear effect pattern provided by the user, generated using the function
\code{\link{collindlnm}}. The number of plots shown is equal to the number
of values passed by \code{at} in the function \code{\link{collindlnm}}.
The way in which these plots are displayed is controlled by the user through
the argument \code{show}.
}
\seealso{
\code{\link{collindlnm}}, \code{\link{plot.collindlnmlinear}}.
}
