% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/priorityqueue.R
\docType{data}
\name{PriorityQueue}
\alias{PriorityQueue}
\title{Priority Queue}
\format{An object of class \code{R6ClassGenerator} of length 24.}
\usage{
PriorityQueue
}
\description{
The \code{PriorityQueue} class creates a priority queue (a.k.a heap).
}
\section{Usage}{

\preformatted{
PriorityQueue$new(items = NULL, priorities = NULL)
PriorityQueue$push(item, priority = 0)
PriorityQueue$pop()
PriorityQueue$clear()
PriorityQueue$size()
PriorityQueue$as_list()
}
}

\section{Argument}{

\itemize{
\item \code{items}: initialization list
\item \code{priorities}: a vector of priorities of the same length of \code{items}
\item \code{item}: any R object
\item \code{priority}: a real number, item with larger priority pops first
}
}

\examples{
q <- PriorityQueue$new()
q$push("not_urgent")
q$push("urgent", priority = 2)
q$push("not_as_urgent", priority = 1)
q$pop()  # urgent
q$pop()  # not_as_urgent
q$pop()  # not_urgent

q <- PriorityQueue$new(list("not_urgent", "urgent"), c(0, 2))
q$push("not_as_urgent", 1)$push("not_urgent2")
}
\keyword{datasets}
